/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.matrix;

import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DDouble;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;

public final class MatrixMath {
    private MatrixMath() {
    }

    public static void sgemm(boolean transA, boolean transB, float alpha, Matrix2DFloat a, Matrix2DFloat b, float beta, Matrix2DFloat c) {
        if (transA) {
            Matrix2DFloat.transpose((Matrix2DFloat)a);
        }
        if (transB) {
            Matrix2DFloat.transpose((Matrix2DFloat)b);
        }
        Matrix2DFloat.scale((Matrix2DFloat)a, (float)alpha);
        for (int row = 0; row < c.getNumRows(); ++row) {
            for (int col = 0; col < c.getNumColumns(); ++col) {
                float sum = c.get(row, col) * beta;
                for (int k = 0; k < b.getNumRows(); ++k) {
                    sum += a.get(row, k) * b.get(k, col);
                }
                c.set(row, col, sum);
            }
        }
    }

    public static void sgemm(Matrix2DFloat a, Matrix2DFloat b, Matrix2DFloat c) {
        MatrixMath.sgemm(false, false, 1.0f, a, b, 0.0f, c);
    }

    public static void sgemm(Matrix4x4Float a, Matrix4x4Float b, Matrix4x4Float c) {
        for (int row = 0; row < c.getNumRows(); ++row) {
            for (int col = 0; col < c.getNumColumns(); ++col) {
                float sum = 0.0f;
                for (int k = 0; k < b.getNumRows(); ++k) {
                    sum += a.get(row, k) * b.get(k, col);
                }
                c.set(row, col, sum);
            }
        }
    }

    public static void dgemm(Matrix2DDouble a, Matrix2DDouble b, Matrix2DDouble c) {
        for (int row = 0; row < c.getNumRows(); ++row) {
            for (int col = 0; col < c.getNumColumns(); ++col) {
                double sum = 0.0;
                for (int k = 0; k < b.getNumRows(); ++k) {
                    sum += a.get(row, k) * b.get(k, col);
                }
                c.set(row, col, sum);
            }
        }
    }

    public static void tred2(double[][] v, double[] d, double[] e, int n) {
        int i;
        int j;
        for (j = 0; j < n; ++j) {
            d[j] = v[n - 1][j];
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    d[j2] = v[i - 1][j2];
                    v[i][j2] = 0.0;
                    v[j2][i] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j4 = 0; j4 < i; ++j4) {
                    e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    v[j4][i] = f = d[j4];
                    g = e[j4] + v[j4][j4] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += v[k2][j4] * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + v[k2][j4] * f;
                    }
                    e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n4 = j4;
                    e[n4] = e[n4] / h;
                    f += e[j4] * d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n5 = j3;
                    e[n5] = e[n5] - hh * d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = d[j3];
                    g = e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        double[] dArray = v[k3];
                        int n6 = j3;
                        dArray[n6] = dArray[n6] - (f * e[k3] + g * d[k3]);
                    }
                    d[j3] = v[i - 1][j3];
                    v[i][j3] = 0.0;
                }
            }
            d[i] = h;
        }
        for (i = 0; i < n - 1; ++i) {
            int k;
            v[n - 1][i] = v[i][i];
            v[i][i] = 1.0;
            double h = d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    d[k] = v[k][i + 1] / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += v[k4][i + 1] * v[k4][j5];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = v[k4];
                        int n7 = j5;
                        dArray[n7] = dArray[n7] - g * d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                v[k][i + 1] = 0.0;
            }
        }
        for (j = 0; j < n; ++j) {
            d[j] = v[n - 1][j];
            v[n - 1][j] = 0.0;
        }
        v[n - 1][n - 1] = 1.0;
        e[0] = 0.0;
    }

    public static void multiply(VectorFloat y, Matrix2DFloat m, VectorFloat x) {
        for (int i = 0; i < m.getNumColumns(); ++i) {
            y.set(i, VectorFloat.dot((VectorFloat)m.row(i), (VectorFloat)x));
        }
    }

    public static FloatArray mult(FloatArray a, FloatArray b) {
        FloatArray result = new FloatArray(6);
        for (int i = 0; i < a.getSize(); ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    public static float dot(FloatArray a, FloatArray b) {
        float result = 0.0f;
        FloatArray m = MatrixMath.mult(a, b);
        for (int i = 0; i < a.getSize(); ++i) {
            result += m.get(i);
        }
        return result;
    }

    public static void multiply(FloatArray y, Matrix2DFloat m, FloatArray x) {
        FloatArray row = new FloatArray(6);
        for (int i = 0; i < row.getSize(); ++i) {
            for (int j = 0; j < row.getSize(); ++j) {
                row.set(j, m.get(i, j));
            }
            y.set(i, MatrixMath.dot(row, x));
        }
    }
}

