/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.vectors;

import java.util.Random;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.vectors.Double3;

public class TestCrossPointTriangles {
    private static int crossPointTriangleTriangle(Double3 v10, Double3 v11, Double3 v12) {
        double tol = 1.0E-6;
        double nTov0 = Double3.dot((Double3)v10, (Double3)v10);
        double nTov1 = Double3.dot((Double3)v11, (Double3)v11);
        double nTov2 = Double3.dot((Double3)v12, (Double3)v12);
        if (TornadoMath.abs((double)nTov0) < 1.0E-6 && TornadoMath.abs((double)nTov1) < 1.0E-6 && TornadoMath.abs((double)nTov2) < 1.0E-6) {
            return 0;
        }
        return 1;
    }

    private static void shortCircuitTestKernel(KernelContext context, DoubleArray a) {
        int[] sVal = context.allocateIntLocalArray(256);
        int localId = context.localIdx;
        int globalId = context.globalIdx;
        if (globalId < a.getSize() / 9) {
            Double3 v10 = new Double3(a.get(globalId * 9), a.get(globalId * 9 + 1), a.get(globalId * 9 + 2));
            Double3 v11 = new Double3(a.get(globalId * 9 + 3), a.get(globalId * 9 + 4), a.get(globalId * 9 + 5));
            Double3 v12 = new Double3(a.get(globalId * 9 + 6), a.get(globalId * 9 + 7), a.get(globalId * 9 + 8));
            sVal[localId] = TestCrossPointTriangles.crossPointTriangleTriangle(v10, v11, v12);
        }
    }

    public static void main() throws TornadoExecutionPlanException {
        TornadoRuntime runtime = TornadoRuntimeProvider.getTornadoRuntime();
        TornadoVMBackendType backendType = runtime.getBackendType(0);
        switch (backendType) {
            case SPIRV: {
                throw new TornadoRuntimeException("Backend not supported");
            }
        }
        DoubleArray tris1 = new DoubleArray(2304);
        Random random = new Random();
        for (int i = 0; i < tris1.getSize(); ++i) {
            tris1.set(i, random.nextDouble());
        }
        WorkerGrid1D workerGrid = new WorkerGrid1D(256);
        GridScheduler gridScheduler = new GridScheduler("TestCrossPointTriangles.shortCircuitTestKernel", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        workerGrid.setLocalWork(256L, 1L, 1L);
        TaskGraph taskGraph = new TaskGraph("TestCrossPointTriangles").transferToDevice(0, new Object[]{tris1}).task("shortCircuitTestKernel", TestCrossPointTriangles::shortCircuitTestKernel, (Object)context, (Object)tris1).transferToHost(0, new Object[]{tris1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executor.withGridScheduler(gridScheduler).execute();
        }
    }
}

