/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.reductions;

import java.util.ArrayList;
import java.util.Random;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.examples.reductions.Stats;

public class ReductionIrregular {
    private static void reduceFloats(FloatArray input, @Reduce FloatArray output) {
        for (int i = 0; i < input.getSize(); ++i) {
            output.set(0, output.get(0) + input.get(i));
        }
    }

    private void run(int inputSize) {
        FloatArray input = new FloatArray(inputSize);
        FloatArray result = FloatArray.fromElements((float[])new float[]{0.0f});
        Random r = new Random(101L);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", ReductionIrregular::reduceFloats, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        ArrayList<Long> timers = new ArrayList<Long>();
        for (int i = 0; i < 101; ++i) {
            IntStream.range(0, inputSize).parallel().forEach(idx -> input.set(idx, r.nextFloat()));
            FloatArray sequential = new FloatArray(1);
            ReductionIrregular.reduceFloats(input, sequential);
            long start = System.nanoTime();
            executor.execute();
            long end = System.nanoTime();
            timers.add(end - start);
            if (Math.abs(sequential.get(0) - result.get(0)) > 0.1f) {
                System.out.println("Result is not correct - iteration: " + i + " expected: " + sequential.get(0) + " but found: " + result.get(0));
                continue;
            }
            System.out.println("Iteration: " + i + " is correct");
        }
        System.out.println("Median TotalTime: " + Stats.computeMedian(timers));
    }

    public static void main(String[] args) {
        int inputSize = 2000;
        if (args.length > 0) {
            inputSize = Integer.parseInt(args[0]);
        }
        System.out.println("Size = " + inputSize);
        new ReductionIrregular().run(inputSize);
    }
}

