/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.reductions;

import java.util.ArrayList;
import java.util.Random;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.examples.reductions.Stats;

public class ReductionAddFloats {
    public static void reductionAddFloats(FloatArray input, @Reduce FloatArray result) {
        for (int i = 0; i < input.getSize(); ++i) {
            result.set(0, result.get(0) + input.get(i));
        }
    }

    public void run(int size) {
        FloatArray input = new FloatArray(size);
        FloatArray result = new FloatArray(1);
        Random r = new Random();
        IntStream.range(0, size).sequential().forEach(i -> input.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", ReductionAddFloats::reductionAddFloats, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        ArrayList<Long> timers = new ArrayList<Long>();
        for (int i2 = 0; i2 < 101; ++i2) {
            long start = System.nanoTime();
            executor.execute();
            long end = System.nanoTime();
            timers.add(end - start);
        }
        System.out.println("Median TotalTime: " + Stats.computeMedian(timers));
    }

    public static void main(String[] args) {
        int inputSize = 8192;
        if (args.length > 0) {
            inputSize = Integer.parseInt(args[0]);
        }
        System.out.println("Size = " + inputSize);
        new ReductionAddFloats().run(inputSize);
    }
}

