/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.reductions;

import java.util.ArrayList;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.examples.reductions.Stats;

public class PiComputation {
    public static void computePi(FloatArray input, @Reduce FloatArray result) {
        result.set(0, 0.0f);
        for (int i = 1; i < 8192; ++i) {
            float value = input.get(i) + TornadoMath.pow((float)-1.0f, (float)(i + 1)) / (float)(2 * i - 1);
            result.set(0, result.get(0) + value);
        }
    }

    public void run(int size) {
        FloatArray input = new FloatArray(size);
        FloatArray result = new FloatArray(1);
        result.init(0.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", PiComputation::computePi, (Object)input, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        ArrayList<Long> timers = new ArrayList<Long>();
        for (int i = 0; i < 101; ++i) {
            IntStream.range(0, size).sequential().forEach(idx -> input.set(idx, 0.0f));
            long start = System.nanoTime();
            executor.execute();
            long end = System.nanoTime();
            float piValue = result.get(0) * 4.0f;
            System.out.println("PI VALUE: " + piValue);
            timers.add(end - start);
        }
        System.out.println("Median TotalTime: " + Stats.computeMedian(timers));
    }

    public static void main(String[] args) {
        int inputSize = 8192;
        if (args.length > 0) {
            inputSize = Integer.parseInt(args[0]);
        }
        System.out.print("Size = " + inputSize + " ");
        new PiComputation().run(inputSize);
    }
}

