/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.reductions;

import java.util.ArrayList;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.examples.reductions.Stats;

public class Integration {
    private static final int LOWER = 1;
    private static final int UPPER = 4;

    public static float f(float x) {
        return 1.0f / ((x + 1.0f) * TornadoMath.sqrt((float)(x * TornadoMath.exp((float)x))));
    }

    public float integrationSequential(int size, float a, float b) {
        float sum = 0.0f;
        for (int i = 1; i < size + 1; ++i) {
            sum += Integration.f(a + ((float)i - 0.5f) * ((b - a) / (float)size));
        }
        return (b - a) / (float)size * sum;
    }

    public float runIntegrationSequential(int size) {
        System.out.println("Running Sequential version");
        float a = 1.0f;
        float b = 4.0f;
        float finalValue = 0.0f;
        ArrayList<Long> timers = new ArrayList<Long>();
        for (int i = 0; i < 101; ++i) {
            long start = System.nanoTime();
            finalValue = this.integrationSequential(size, 1.0f, 4.0f);
            long end = System.nanoTime();
            timers.add(end - start);
        }
        System.out.println("IntegrationValue: " + finalValue);
        System.out.println("Median TotalTime: " + Stats.computeMedian(timers));
        return finalValue;
    }

    public static void integrationTornado(FloatArray input, @Reduce FloatArray sum, float a, float b) {
        int size = input.getSize();
        for (int i = 0; i < input.getSize(); ++i) {
            float value = Integration.f(a + (float)(i + 1 - 0) * ((b - a) / (float)size));
            sum.set(0, sum.get(0) + input.get(i) + value);
        }
    }

    public float runTornado(int size) {
        System.out.println("\nRunning Tornado version");
        FloatArray input = new FloatArray(size);
        FloatArray result = new FloatArray(1);
        result.init(0.0f);
        float a = 1.0f;
        float b = 4.0f;
        float finalValue = 0.0f;
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, Float.valueOf(1.0f), Float.valueOf(4.0f)}).task("t0", Integration::integrationTornado, (Object)input, (Object)result, (Object)Float.valueOf(1.0f), (Object)Float.valueOf(4.0f)).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        ArrayList<Long> timers = new ArrayList<Long>();
        for (int i = 0; i < 101; ++i) {
            IntStream.range(0, size).sequential().forEach(idx -> input.set(idx, 0.0f));
            long start = System.nanoTime();
            executor.execute();
            long end = System.nanoTime();
            finalValue = 3.0f / (float)size * result.get(0);
            timers.add(end - start);
        }
        System.out.println("IntegrationValue: " + finalValue);
        System.out.println("Median TotalTime: " + Stats.computeMedian(timers));
        return finalValue;
    }

    public static void main(String[] args) {
        int size = 8192;
        if (args.length > 0) {
            try {
                size = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                size = 8192;
            }
        }
        new Integration().runTornado(size);
    }
}

