/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.polyglot.node;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;

public class Mandelbrot {
    private static final int SIZE = 1024;

    private static void mandelbrot(int size, short[] output) {
        int iterations = 10000;
        float space = 2.0f / (float)size;
        for (int i = 0; i < size; ++i) {
            int indexIDX = i;
            for (int j = 0; j < size; ++j) {
                short r;
                int indexJDX = j;
                float Zr = 0.0f;
                float Zi = 0.0f;
                float Cr = (float)(1 * indexJDX) * space - 1.5f;
                float Ci = (float)(1 * indexIDX) * space - 1.0f;
                float ZrN = 0.0f;
                float ZiN = 0.0f;
                int y = 0;
                for (int ii = 0; ii < 10000; ++ii) {
                    if (ZiN + ZrN <= 4.0f) {
                        Zi = 2.0f * Zr * Zi + Ci;
                        Zr = 1.0f * ZrN - ZiN + Cr;
                        ZiN = Zi * Zi;
                        ZrN = Zr * Zr;
                        ++y;
                        continue;
                    }
                    ii = 10000;
                }
                output[i * size + j] = r = (short)(y * 255 / 10000);
            }
        }
    }

    private static BufferedImage writeFile(short[] output, int size) {
        BufferedImage img = null;
        try {
            img = new BufferedImage(size, size, 4);
            WritableRaster write = img.getRaster();
            File outputFile = new File("./mandelbrot.png");
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    short colour = output[i * size + j];
                    write.setSample(i, j, 0, colour);
                }
            }
            ImageIO.write((RenderedImage)img, "PNG", outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public static short[] sequential() {
        short[] result = new short[0x100000];
        Mandelbrot.mandelbrot(1024, result);
        Mandelbrot.writeFile(result, 1024);
        return result;
    }

    public static String getString() {
        return "Hello from Java - TornadoVM - Computing Mandelbrot";
    }

    public static short[] compute() {
        short[] result = new short[0x100000];
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", Mandelbrot::mandelbrot, (Object)1024, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        Mandelbrot.writeFile(result, 1024);
        return result;
    }
}

