/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.polyglot;

import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;

public final class MyCompute {
    private static TornadoExecutionPlan executor;

    private MyCompute() {
    }

    private static void mxm(float[] a, float[] b, float[] c, int N) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < N; ++k) {
                    sum += a[i * N + k] + b[k + N + j];
                }
                c[i * N + j] = sum;
            }
        }
    }

    public static float[] compute() {
        int N = 512;
        float[] a = new float[262144];
        float[] b = new float[262144];
        float[] c = new float[262144];
        IntStream.range(0, 262144).sequential().forEach(i -> {
            a[i] = 2.0f;
            b[i] = 1.4f;
        });
        if (executor == null) {
            TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", MyCompute::mxm, (Object)a, (Object)b, (Object)c, (Object)512).transferToHost(1, new Object[]{c});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        }
        executor.execute();
        return c;
    }
}

