/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.memory;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class TestMemory {
    public static void moveData(FloatArray inputArray, FloatArray outputArray) {
        for (int i = 0; i < inputArray.getSize(); ++i) {
            outputArray.set(i, inputArray.get(i));
        }
    }

    public static void stressDataAllocationTest(int dataSizeFactor) throws TornadoExecutionPlanException {
        System.out.println("Allocating size: " + dataSizeFactor * 4 + " (bytes)");
        FloatArray inputArray = new FloatArray(dataSizeFactor);
        FloatArray outputArray = new FloatArray(dataSizeFactor);
        inputArray.init(0.1f);
        TaskGraph taskGraph = new TaskGraph("memory" + dataSizeFactor).transferToDevice(1, new Object[]{inputArray}).task("stress", TestMemory::moveData, (Object)inputArray, (Object)outputArray).transferToHost(1, new Object[]{outputArray});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    public static void main(String[] args) {
        for (int i = 400; i < 500; i += 10) {
            int size = 0x100000 * i;
            try {
                TestMemory.stressDataAllocationTest(size);
                continue;
            }
            catch (TornadoExecutionPlanException e) {
                e.printStackTrace();
            }
        }
    }
}

