/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.matrices;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat4;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public class MatrixAddition2D {
    private static final int WARMING_UP_ITERATIONS = 25;

    private static void matrixAddition(Matrix2DFloat A, Matrix2DFloat B, Matrix2DFloat C, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                C.set(i, j, A.get(i, j) + B.get(j, j));
            }
        }
    }

    private static void matrixAddition(Matrix2DFloat4 A, Matrix2DFloat4 B, Matrix2DFloat4 C, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                C.set(i, j, Float4.add((Float4)A.get(i, j), (Float4)B.get(j, j)));
            }
        }
    }

    private static void reset() {
        for (int i = 0; i < TornadoRuntimeProvider.getTornadoRuntime().getNumBackends(); ++i) {
            TornadoBackend driver = TornadoRuntimeProvider.getTornadoRuntime().getBackend(i);
            driver.getDefaultDevice().clean();
        }
    }

    public static void main(String[] args) {
        int size = 512;
        if (args.length >= 1) {
            try {
                size = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println("Computing Matrix Addition of " + size + "x" + size);
        Matrix2DFloat matrixA = new Matrix2DFloat(size, size);
        Matrix2DFloat matrixB = new Matrix2DFloat(size, size);
        Matrix2DFloat matrixC = new Matrix2DFloat(size, size);
        Matrix2DFloat resultSeq = new Matrix2DFloat(size, size);
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrixA.set(i, j, r.nextFloat());
                matrixB.set(i, j, r.nextFloat());
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", MatrixAddition2D::matrixAddition, (Object)matrixA, (Object)matrixB, (Object)matrixC, (Object)size).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        for (int i = 0; i < 25; ++i) {
            executor.execute();
        }
        long start = System.nanoTime();
        executor.execute();
        long end = System.nanoTime();
        MatrixAddition2D.reset();
        Matrix2DFloat4 matrixAV = new Matrix2DFloat4(size /= 2, size);
        Matrix2DFloat4 matrixBV = new Matrix2DFloat4(size, size);
        Matrix2DFloat4 matrixCV = new Matrix2DFloat4(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrixAV.set(i, j, new Float4(r.nextFloat(), r.nextFloat(), r.nextFloat(), r.nextFloat()));
                matrixBV.set(i, j, new Float4(r.nextFloat(), r.nextFloat(), r.nextFloat(), r.nextFloat()));
            }
        }
        TaskGraph taskGraph1 = new TaskGraph("s1").transferToDevice(0, new Object[]{matrixAV, matrixBV}).task("t1", MatrixAddition2D::matrixAddition, (Object)matrixAV, (Object)matrixBV, (Object)matrixCV, (Object)(size * 2)).transferToHost(1, new Object[]{matrixCV});
        ImmutableTaskGraph immutableTaskGraph1 = taskGraph1.snapshot();
        TornadoExecutionPlan executor1 = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph1});
        for (int i = 0; i < 25; ++i) {
            executor1.execute();
        }
        long startVector = System.nanoTime();
        executor1.execute();
        long endVector = System.nanoTime();
        for (int i = 0; i < 25; ++i) {
            MatrixAddition2D.matrixAddition(matrixA, matrixB, resultSeq, size);
        }
        long startSequential = System.nanoTime();
        MatrixAddition2D.matrixAddition(matrixA, matrixB, resultSeq, size);
        long endSequential = System.nanoTime();
        double speedup = (double)(endSequential - startSequential) / (double)(end - start);
        double speedupVector = (double)(endSequential - startSequential) / (double)(endVector - startVector);
        System.out.println("\tCPU Sequential Total Time = " + (endSequential - startSequential) + " ns");
        System.out.println("\tGPU TornadoVM  Total Time = " + (end - start) + " ns");
        System.out.println("\tGPU TornadoVM  Vector Total Time = " + (endVector - startVector) + " ns");
        System.out.println("\tSpeedup Seq/TornadoVM: " + speedup + "x");
        System.out.println("\tSpeedup Seq/TornadoVM Vector: " + speedupVector + "x");
    }
}

