/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.reductions;

import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class ReductionsLocalMemory {
    public static void reductionLocal(FloatArray a, FloatArray b, int localSize, KernelContext context) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        float[] localA = context.allocateFloatLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = localA[n] + localA[localIdx + stride];
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static float computeSequential(FloatArray input) {
        float acc = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            acc += input.get(i);
        }
        return acc;
    }

    public static void rAdd(FloatArray array, int size) {
        float acc = array.get(0);
        for (int i = 1; i < array.getSize(); ++i) {
            acc += array.get(i);
        }
        array.set(0, acc);
    }

    public static void main(String[] args) {
        int size = 1024;
        int localSize = 256;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = ReductionsLocalMemory.computeSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler();
        gridScheduler.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", ReductionsLocalMemory::reductionLocal, (Object)input, (Object)reduce, (Object)256, (Object)context).task("t1", ReductionsLocalMemory::rAdd, (Object)reduce, (Object)4).transferToHost(1, new Object[]{reduce});
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withGridScheduler(gridScheduler).execute();
        float finalSum = reduce.get(0);
        System.out.println("Final SUM = " + finalSum + " vs seq= " + sequential);
        if (sequential - finalSum == 0.0f) {
            System.out.println("Result is correct");
        } else {
            System.out.println("Result is wrong");
        }
    }
}

