/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.reductions;

import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class ReductionsGlobalMemory {
    public static void reduction(FloatArray a, FloatArray b, KernelContext context) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, a.get(id) + a.get(id + stride));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static float computeSequential(FloatArray input) {
        float acc = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            acc += input.get(i);
        }
        return acc;
    }

    public static void rAdd(FloatArray array, int size) {
        float acc = array.get(0);
        for (int i = 1; i < array.getSize(); ++i) {
            acc += array.get(i);
        }
        array.set(0, acc);
    }

    public static void main(String[] args) {
        int size = 1024;
        FloatArray input = new FloatArray(1024);
        FloatArray reduce = new FloatArray(1024);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (float)i));
        float sequential = ReductionsGlobalMemory.computeSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler();
        gridScheduler.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", ReductionsGlobalMemory::reduction, (Object)input, (Object)reduce, (Object)context).task("t1", ReductionsGlobalMemory::rAdd, (Object)reduce, (Object)1024).transferToHost(1, new Object[]{reduce});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withGridScheduler(gridScheduler).execute();
        float finalSum = reduce.get(0);
        System.out.println("Final SUM = " + finalSum + " vs seq= " + sequential);
        if (sequential - finalSum == 0.0f) {
            System.out.println("Result is correct");
        } else {
            System.out.println("Result is wrong");
        }
    }
}

