/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.reductions;

import java.util.Random;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class Histogram {
    private static final int NUM_BINS = 4;
    private static int BLOCK_SIZE = 256;
    private static int size = 256;

    public static void histogramKernel(KernelContext context, IntArray input, IntArray output) {
        int tid = context.globalIdx;
        if (tid < input.getSize()) {
            int index = input.get(tid);
            context.atomicAdd(output, index, 1);
        }
    }

    public static void histogram(KernelContext context, IntArray input, IntArray output) {
        for (int tid = 0; tid < input.getSize(); ++tid) {
            int index = input.get(tid);
            context.atomicAdd(output, index, 1);
            output.set(index, output.get(index));
        }
    }

    public static void main(String[] args) throws TornadoExecutionPlanException {
        if (args.length == 1) {
            size = Integer.parseInt(args[0]);
        } else if (args.length == 2) {
            size = Integer.parseInt(args[0]);
            BLOCK_SIZE = Integer.parseInt(args[1]);
        }
        Random rand = new Random();
        IntArray inputData = new IntArray(size);
        IntArray histDataTornado = new IntArray(size);
        IntArray histDataJava = new IntArray(size);
        for (int i = 0; i < size; ++i) {
            inputData.set(i, rand.nextInt(4));
        }
        inputData.init(2);
        KernelContext context = new KernelContext();
        WorkerGrid1D workerGrid = new WorkerGrid1D(size);
        workerGrid.setGlobalWork((long)size, 1L, 1L);
        workerGrid.setLocalWork((long)BLOCK_SIZE, 1L, 1L);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{inputData}).task("t0", Histogram::histogramKernel, (Object)context, (Object)inputData, (Object)histDataTornado).transferToHost(1, new Object[]{histDataTornado});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        Histogram.histogram(context, inputData, histDataJava);
        boolean validation = Histogram.validate(histDataTornado, histDataJava);
        if (validation) {
            System.out.println("Validation [PASSED].");
        } else {
            System.out.println("Validation [FAILED].");
        }
    }

    private static boolean validate(IntArray histDataTornado, IntArray histDataJava) {
        int counter = 0;
        for (int i = 0; i < 5; ++i) {
            counter += histDataTornado.get(i);
            if (histDataJava.get(i) == histDataTornado.get(i)) continue;
            System.out.println("[FAIL] histDataJava.get(" + i + "): " + histDataJava.get(i) + " - histDataTornado.get(" + i + "): " + histDataTornado.get(i));
            return false;
        }
        return counter == histDataTornado.getSize();
    }
}

