/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.compute;

import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.profiler.ChromeEventTracer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class NBody {
    private static boolean VALIDATION = true;
    private static float DELT = 0.005f;
    private static float ESP_SQR = 500.0f;

    private static void nBody(KernelContext context, int numBodies, FloatArray refPos, FloatArray refVel) {
        int i = context.globalIdx;
        int body = 4 * i;
        float[] acc = new float[]{0.0f, 0.0f, 0.0f};
        for (int j = 0; j < numBodies; ++j) {
            float[] r = new float[3];
            int index = 4 * j;
            float distSqr = 0.0f;
            for (int k = 0; k < 3; ++k) {
                r[k] = refPos.get(index + k) - refPos.get(body + k);
                distSqr += r[k] * r[k];
            }
            float invDist = (float)(1.0 / Math.sqrt(distSqr + ESP_SQR));
            float invDistCube = invDist * invDist * invDist;
            float s = refPos.get(index + 3) * invDistCube;
            for (int k = 0; k < 3; ++k) {
                int n = k;
                acc[n] = acc[n] + s * r[k];
            }
        }
        for (int k = 0; k < 3; ++k) {
            refPos.set(body + k, refPos.get(body + k) + refVel.get(body + k) * DELT + 0.5f * acc[k] * DELT * DELT);
            refVel.set(body + k, refVel.get(body + k) + acc[k] * DELT);
        }
    }

    private static void nBody(int numBodies, FloatArray refPos, FloatArray refVel) {
        for (int i = 0; i < numBodies; ++i) {
            int body = 4 * i;
            float[] acc = new float[]{0.0f, 0.0f, 0.0f};
            for (int j = 0; j < numBodies; ++j) {
                float[] r = new float[3];
                int index = 4 * j;
                float distSqr = 0.0f;
                for (int k = 0; k < 3; ++k) {
                    r[k] = refPos.get(index + k) - refPos.get(body + k);
                    distSqr += r[k] * r[k];
                }
                float invDist = (float)(1.0 / Math.sqrt(distSqr + ESP_SQR));
                float invDistCube = invDist * invDist * invDist;
                float s = refPos.get(index + 3) * invDistCube;
                for (int k = 0; k < 3; ++k) {
                    int n = k;
                    acc[n] = acc[n] + s * r[k];
                }
            }
            for (int k = 0; k < 3; ++k) {
                refPos.set(body + k, refPos.get(body + k) + refVel.get(body + k) * DELT + 0.5f * acc[k] * DELT * DELT);
                refVel.set(body + k, refVel.get(body + k) + acc[k] * DELT);
            }
        }
    }

    public static boolean validate(int numBodies, FloatArray posTornadoVM, FloatArray velTornadoVM, FloatArray posSequential, FloatArray velSequential) {
        boolean isValid = true;
        for (int i = 0; i < numBodies * 4; ++i) {
            if ((double)Math.abs(posSequential.get(i) - posTornadoVM.get(i)) > 0.1) {
                isValid = false;
                break;
            }
            if (!((double)Math.abs(velSequential.get(i) - velTornadoVM.get(i)) > 0.1)) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    public static void main(String[] args) {
        int i;
        StringBuffer resultsIterations = new StringBuffer();
        int numBodies = 32768;
        int iterations = 10;
        if (args.length == 2) {
            numBodies = Integer.parseInt(args[0]);
            iterations = Integer.parseInt(args[1]);
        } else if (args.length == 1) {
            numBodies = Integer.parseInt(args[0]);
        }
        System.out.println("Running Nbody with " + numBodies + " bodies and " + iterations + " iterations");
        FloatArray posSeq = new FloatArray(numBodies * 4);
        FloatArray velSeq = new FloatArray(numBodies * 4);
        for (i = 0; i < posSeq.getSize(); ++i) {
            posSeq.set(i, (float)Math.random());
        }
        velSeq.init(0.0f);
        FloatArray posTornadoVM = new FloatArray(numBodies * 4);
        FloatArray velTornadoVM = new FloatArray(numBodies * 4);
        for (i = 0; i < posSeq.getSize(); ++i) {
            posTornadoVM.set(i, posSeq.get(i));
        }
        for (i = 0; i < velSeq.getSize(); ++i) {
            velTornadoVM.set(i, velSeq.get(i));
        }
        long start = 0L;
        long end = 0L;
        for (int i2 = 0; i2 < iterations; ++i2) {
            System.gc();
            start = System.nanoTime();
            NBody.nBody(numBodies, posSeq, velSeq);
            end = System.nanoTime();
            ChromeEventTracer.enqueueTaskIfEnabled((String)"nbody sequential", (long)start, (long)end);
            resultsIterations.append("\tSequential execution time of iteration " + i2 + "is: " + (end - start) + " ns");
            resultsIterations.append("\n");
        }
        long timeSequential = end - start;
        System.out.println(resultsIterations);
        WorkerGrid1D workerGrid = new WorkerGrid1D(numBodies);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        workerGrid.setGlobalWork((long)numBodies, 1L, 1L);
        workerGrid.setLocalWork(1024L, 1L, 1L);
        TaskGraph t0 = new TaskGraph("s0").transferToDevice(0, new Object[]{posTornadoVM, velTornadoVM}).task("t0", NBody::nBody, (Object)context, (Object)numBodies, (Object)posTornadoVM, (Object)velTornadoVM).transferToHost(1, new Object[]{posTornadoVM, velTornadoVM});
        ImmutableTaskGraph immutableTaskGraph = t0.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withGridScheduler(gridScheduler);
        resultsIterations = new StringBuffer();
        for (int i3 = 0; i3 < iterations; ++i3) {
            System.gc();
            start = System.nanoTime();
            executor.execute();
            end = System.nanoTime();
            ChromeEventTracer.enqueueTaskIfEnabled((String)"nbody accelerated", (long)start, (long)end);
            resultsIterations.append("\tTornado execution time of iteration " + i3 + " is: " + (end - start) + " ns");
            resultsIterations.append("\n");
        }
        long timeParallel = end - start;
        System.out.println(resultsIterations.toString());
        if (VALIDATION) {
            boolean isValid = NBody.validate(numBodies, posTornadoVM, velTornadoVM, posSeq, velSeq);
            if (isValid) {
                System.out.println("Result is correct");
            } else {
                System.out.println("Result is wrong");
            }
        }
        System.out.println("Sequential time: " + timeSequential + " ns");
        System.out.println("TornadoVM time: " + timeParallel + " ns");
        System.out.println("Speedup in peak performance: " + timeSequential / timeParallel + "x");
    }
}

