/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.compute;

import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class Montecarlo {
    private static void computeMontecarlo(KernelContext context, FloatArray output, int iterations) {
        int j = context.globalIdx;
        long seed = j;
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        float x = (float)(seed & 0xFFFFFFFL) / 2.6843546E8f;
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        float y = (float)((seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) & 0xFFFFFFFL) / 2.6843546E8f;
        float dist = (float)Math.sqrt(x * x + y * y);
        if (dist <= 1.0f) {
            output.set(j, 1.0f);
        } else {
            output.set(j, 0.0f);
        }
    }

    private static void computeMontecarlo(FloatArray output, int iterations) {
        for (int j = 0; j < iterations; ++j) {
            long seed = j;
            seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            float x = (float)(seed & 0xFFFFFFFL) / 2.6843546E8f;
            seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            float y = (float)((seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) & 0xFFFFFFFL) / 2.6843546E8f;
            float dist = (float)Math.sqrt(x * x + y * y);
            if (dist <= 1.0f) {
                output.set(j, 1.0f);
                continue;
            }
            output.set(j, 0.0f);
        }
    }

    public static void montecarlo(int size) {
        FloatArray output = new FloatArray(size);
        FloatArray seq = new FloatArray(size);
        WorkerGrid1D workerGrid = new WorkerGrid1D(size);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        workerGrid.setGlobalWork((long)size, 1L, 1L);
        workerGrid.setLocalWork(1024L, 1L, 1L);
        TaskGraph t0 = new TaskGraph("s0").task("t0", Montecarlo::computeMontecarlo, (Object)context, (Object)output, (Object)size).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = t0.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withGridScheduler(gridScheduler);
        long start = System.nanoTime();
        executor.execute();
        long end = System.nanoTime();
        long tornadoTime = end - start;
        float sum = 0.0f;
        for (int j = 0; j < size; ++j) {
            sum += output.get(j);
        }
        System.out.println("Total time (Tornado)   : " + tornadoTime);
        System.out.println("Pi value(Tornado)   : " + (sum *= 4.0f) / (float)size);
        start = System.nanoTime();
        Montecarlo.computeMontecarlo(seq, size);
        end = System.nanoTime();
        long sequentialTime = end - start;
        sum = 0.0f;
        for (int j = 0; j < size; ++j) {
            sum += seq.get(j);
        }
        System.out.println("Total time (Sequential): " + sequentialTime);
        System.out.println("Pi value(seq)   : " + (sum *= 4.0f) / (float)size);
        double speedup = (double)sequentialTime / (double)tornadoTime;
        System.out.println("Speedup: " + speedup);
    }

    public static void main(String[] args) {
        System.out.println("Compute Montecarlo");
        Montecarlo.montecarlo(0x1000000);
    }
}

