/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.compute;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid2D;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;

public class Mandelbrot {
    public static final int SIZE = 256;
    public static final boolean USE_TORNADO = true;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Mandelbrot Example within Tornado");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        frame.add(new MandelbrotImage());
        frame.pack();
        frame.setVisible(true);
    }

    public static class MandelbrotImage
    extends Component {
        private BufferedImage image;

        private static ShortArray mandelbrotSequential(int size) {
            int iterations = 10000;
            float space = 2.0f / (float)size;
            ShortArray result = new ShortArray(size * size);
            for (int i = 0; i < size; ++i) {
                int indexIDX = i;
                for (int j = 0; j < size; ++j) {
                    int y;
                    int indexJDX = j;
                    float Zr = 0.0f;
                    float Zi = 0.0f;
                    float Cr = (float)(1 * indexJDX) * space - 1.5f;
                    float Ci = (float)(1 * indexIDX) * space - 1.0f;
                    float ZrN = 0.0f;
                    float ZiN = 0.0f;
                    for (y = 0; y < 10000 && ZiN + ZrN <= 4.0f; ++y) {
                        Zi = 2.0f * Zr * Zi + Ci;
                        Zr = 1.0f * ZrN - ZiN + Cr;
                        ZiN = Zi * Zi;
                        ZrN = Zr * Zr;
                    }
                    short r = (short)(y * 255 / 10000);
                    result.set(i * size + j, r);
                }
            }
            return result;
        }

        private static void mandelbrotTornado(KernelContext context, int size, ShortArray output) {
            int iterations = 10000;
            float space = 2.0f / (float)size;
            int i = context.globalIdx;
            int j = context.globalIdy;
            float Zr = 0.0f;
            float Zi = 0.0f;
            float Cr = (float)(1 * j) * space - 1.5f;
            float Ci = (float)(1 * i) * space - 1.0f;
            float ZrN = 0.0f;
            float ZiN = 0.0f;
            int y = 0;
            for (int ii = 0; ii < 10000; ++ii) {
                if (ZiN + ZrN <= 4.0f) {
                    Zi = 2.0f * Zr * Zi + Ci;
                    Zr = 1.0f * ZrN - ZiN + Cr;
                    ZiN = Zi * Zi;
                    ZrN = Zr * Zr;
                    ++y;
                    continue;
                }
                ii = 10000;
            }
            short r = (short)(y * 255 / 10000);
            output.set(i * size + j, r);
        }

        private static BufferedImage writeFile(ShortArray output, int size) {
            BufferedImage img = null;
            try {
                img = new BufferedImage(size, size, 4);
                WritableRaster write = img.getRaster();
                File outputFile = new File("/home/mary/Pictures/Wallpapers/test.jpg");
                for (int i = 0; i < size; ++i) {
                    for (int j = 0; j < size; ++j) {
                        short colour = output.get(i * size + j);
                        write.setSample(i, j, 0, colour);
                    }
                }
                ImageIO.write((RenderedImage)img, "PNG", outputFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return img;
        }

        @Override
        public void paint(Graphics g) {
            ShortArray result = new ShortArray(65536);
            WorkerGrid2D workerGrid = new WorkerGrid2D(256, 256);
            GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
            KernelContext context = new KernelContext();
            workerGrid.setGlobalWork(256L, 256L, 1L);
            workerGrid.setLocalWork(32L, 32L, 1L);
            TaskGraph taskGraph = new TaskGraph("s0").task("t0", MandelbrotImage::mandelbrotTornado, (Object)context, (Object)256, (Object)result).transferToHost(1, new Object[]{result});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            executor.withGridScheduler(gridScheduler).execute();
            this.image = MandelbrotImage.writeFile(result, 256);
            g.drawImage(this.image, 0, 0, null);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.image == null) {
                return new Dimension(256, 256);
            }
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
    }
}

