/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.compute;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid2D;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class BlurFilter {
    public static void main(String[] args) {
        JFrame frame = new JFrame("Blur Image Filter Example with TornadoVM");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        frame.add(new BlurFilterImage());
        frame.pack();
        frame.setVisible(true);
    }

    public static class BlurFilterImage
    extends Component {
        public static final boolean PARALLEL_COMPUTATION = Boolean.parseBoolean(System.getProperty("run:parallel", "True"));
        public static final int FILTER_WIDTH = 31;
        private static final String IMAGE_FILE = "/tmp/image.jpg";
        private BufferedImage image;

        public BlurFilterImage() {
            this.loadImage();
        }

        private static void channelConvolutionSequential(IntArray channel, IntArray channelBlurred, int numRows, int numCols, FloatArray filter, int filterWidth) {
            assert (filterWidth % 2 == 1);
            for (int r = 0; r < numRows; ++r) {
                for (int c = 0; c < numCols; ++c) {
                    float result = 0.0f;
                    for (int filter_r = -filterWidth / 2; filter_r <= filterWidth / 2; ++filter_r) {
                        for (int filter_c = -filterWidth / 2; filter_c <= filterWidth / 2; ++filter_c) {
                            int image_r = Math.min(Math.max(r + filter_r, 0), numRows - 1);
                            int image_c = Math.min(Math.max(c + filter_c, 0), numCols - 1);
                            float image_value = channel.get(image_r * numCols + image_c);
                            float filter_value = filter.get((filter_r + filterWidth / 2) * filterWidth + filter_c + filterWidth / 2);
                            result += image_value * filter_value;
                        }
                    }
                    channelBlurred.set(r * numCols + c, result > 255.0f ? 255 : (int)result);
                }
            }
        }

        private static void compute(KernelContext context, IntArray channel, IntArray channelBlurred, int numRows, int numCols, FloatArray filter, int filterWidth) {
            assert (filterWidth % 2 == 1);
            int r = context.globalIdy;
            int c = context.globalIdx;
            float result = 0.0f;
            for (int filter_r = -filterWidth / 2; filter_r <= filterWidth / 2; ++filter_r) {
                for (int filter_c = -filterWidth / 2; filter_c <= filterWidth / 2; ++filter_c) {
                    int image_r = Math.min(Math.max(r + filter_r, 0), numRows - 1);
                    int image_c = Math.min(Math.max(c + filter_c, 0), numCols - 1);
                    float image_value = channel.get(image_r * numCols + image_c);
                    float filter_value = filter.get((filter_r + filterWidth / 2) * filterWidth + filter_c + filterWidth / 2);
                    result += image_value * filter_value;
                }
            }
            channelBlurred.set(r * numCols + c, result > 255.0f ? 255 : (int)result);
        }

        public void loadImage() {
            try {
                this.image = ImageIO.read(new File(IMAGE_FILE));
            }
            catch (IOException e) {
                throw new RuntimeException("Input file not found: /tmp/image.jpg");
            }
        }

        private void parallelCompute() {
            int j;
            int i;
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            IntArray redChannel = new IntArray(w * h);
            IntArray greenChannel = new IntArray(w * h);
            IntArray blueChannel = new IntArray(w * h);
            IntArray alphaChannel = new IntArray(w * h);
            IntArray redFilter = new IntArray(w * h);
            IntArray greenFilter = new IntArray(w * h);
            IntArray blueFilter = new IntArray(w * h);
            FloatArray filter = new FloatArray(w * h);
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    filter.set(i * h + j, 0.0010405828f);
                }
            }
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    int rgb = this.image.getRGB(i, j);
                    alphaChannel.set(i * h + j, rgb >> 24 & 0xFF);
                    redChannel.set(i * h + j, rgb >> 16 & 0xFF);
                    greenChannel.set(i * h + j, rgb >> 8 & 0xFF);
                    blueChannel.set(i * h + j, rgb & 0xFF);
                }
            }
            long start = System.nanoTime();
            WorkerGrid2D workerGrid = new WorkerGrid2D(w, h);
            GridScheduler gridScheduler = new GridScheduler("blur.red", (WorkerGrid)workerGrid);
            gridScheduler.addWorkerGrid("blur.green", (WorkerGrid)workerGrid);
            gridScheduler.addWorkerGrid("blur.blue", (WorkerGrid)workerGrid);
            KernelContext context = new KernelContext();
            TaskGraph parallelFilter = new TaskGraph("blur").transferToDevice(0, new Object[]{redChannel, greenChannel, blueChannel, filter}).task("red", BlurFilterImage::compute, (Object)context, (Object)redChannel, (Object)redFilter, (Object)w, (Object)h, (Object)filter, (Object)31).task("green", BlurFilterImage::compute, (Object)context, (Object)greenChannel, (Object)greenFilter, (Object)w, (Object)h, (Object)filter, (Object)31).task("blue", BlurFilterImage::compute, (Object)context, (Object)blueChannel, (Object)blueFilter, (Object)w, (Object)h, (Object)filter, (Object)31).transferToHost(1, new Object[]{redFilter, greenFilter, blueFilter});
            ImmutableTaskGraph immutableTaskGraph = parallelFilter.snapshot();
            TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            workerGrid.setGlobalWork((long)h, (long)w, 1L);
            workerGrid.setLocalWorkToNull();
            executor.withGridScheduler(gridScheduler).execute();
            for (int i2 = 0; i2 < w; ++i2) {
                for (int j2 = 0; j2 < h; ++j2) {
                    Color c = new Color(redFilter.get(i2 * h + j2), greenFilter.get(i2 * h + j2), blueFilter.get(i2 * h + j2), alphaChannel.get(i2 * h + j2));
                    this.image.setRGB(i2, j2, c.getRGB());
                }
            }
            long end = System.nanoTime();
            System.out.println("Parallel Total time: \n\tns = " + (end - start) + "\n\tseconds = " + (double)(end - start) * 1.0E-9);
        }

        private void sequentialComputation() {
            int j;
            int i;
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            IntArray redChannel = new IntArray(w * h);
            IntArray greenChannel = new IntArray(w * h);
            IntArray blueChannel = new IntArray(w * h);
            IntArray alphaChannel = new IntArray(w * h);
            IntArray redFilter = new IntArray(w * h);
            IntArray greenFilter = new IntArray(w * h);
            IntArray blueFilter = new IntArray(w * h);
            FloatArray filter = new FloatArray(w * h);
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    filter.set(i * h + j, 0.0010405828f);
                }
            }
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    int rgb = this.image.getRGB(i, j);
                    alphaChannel.set(i * h + j, rgb >> 24 & 0xFF);
                    redChannel.set(i * h + j, rgb >> 16 & 0xFF);
                    greenChannel.set(i * h + j, rgb >> 8 & 0xFF);
                    blueChannel.set(i * h + j, rgb & 0xFF);
                }
            }
            long start = System.nanoTime();
            BlurFilterImage.channelConvolutionSequential(redChannel, redFilter, w, h, filter, 31);
            BlurFilterImage.channelConvolutionSequential(greenChannel, greenFilter, w, h, filter, 31);
            BlurFilterImage.channelConvolutionSequential(blueChannel, blueFilter, w, h, filter, 31);
            for (int i2 = 0; i2 < w; ++i2) {
                for (int j2 = 0; j2 < h; ++j2) {
                    Color c = new Color(redFilter.get(i2 * h + j2), greenFilter.get(i2 * h + j2), blueFilter.get(i2 * h + j2), alphaChannel.get(i2 * h + j2));
                    this.image.setRGB(i2, j2, c.getRGB());
                }
            }
            long end = System.nanoTime();
            System.out.println("Sequential Total time: \n\tns = " + (end - start) + "\n\tseconds = " + (double)(end - start) * 1.0E-9);
        }

        @Override
        public void paint(Graphics g) {
            this.loadImage();
            if (PARALLEL_COMPUTATION) {
                this.parallelCompute();
            } else {
                this.sequentialComputation();
            }
            g.drawImage(this.image, 0, 0, null);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.image == null) {
                return new Dimension(100, 100);
            }
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
    }
}

