/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.kernelcontext.compute;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid2D;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class BlackAndWhiteTransform {
    public static void main(String[] args) {
        JFrame frame = new JFrame("Image Grey-scale conversion example with TornadoVM");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        frame.add(new LoadImage());
        frame.pack();
        frame.setVisible(true);
    }

    public static class LoadImage
    extends Component {
        private static final int WARMING_UP_ITERATIONS = 15;
        private static final long serialVersionUID = 1L;
        private static final boolean PARALLEL_COMPUTATION = Boolean.parseBoolean(System.getProperty("run::parallel", "False"));
        private static final String IMAGE_FILE = "/tmp/image.jpg";
        private static TornadoExecutionPlan executor;
        private static WorkerGrid workerGrid;
        private static GridScheduler gridScheduler;
        private BufferedImage image;

        LoadImage() {
            try {
                this.image = ImageIO.read(new File(IMAGE_FILE));
            }
            catch (IOException e) {
                throw new RuntimeException("Input file not found: /tmp/image.jpg");
            }
        }

        private static void compute2D(KernelContext context, IntArray image, int w, int s) {
            int idx = context.globalIdy;
            int jdx = context.globalIdx;
            int rgb = image.get(idx * s + jdx);
            int alpha = rgb >> 24 & 0xFF;
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            int grayLevel = (red + green + blue) / 3;
            int gray = alpha << 24 | grayLevel << 16 | grayLevel << 8 | grayLevel;
            image.set(idx * s + jdx, gray);
        }

        private static void compute1D(KernelContext context, IntArray image, int w, int s) {
            int idx = context.globalIdx;
            int rgb = image.get(idx);
            int alpha = rgb >> 24 & 0xFF;
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            int grayLevel = (red + green + blue) / 3;
            int gray = alpha << 24 | grayLevel << 16 | grayLevel << 8 | grayLevel;
            image.set(idx, gray);
        }

        private void writeImage(String fileName) {
            try {
                ImageIO.write((RenderedImage)this.image, "jpg", new File("/tmp/" + fileName));
            }
            catch (IOException e) {
                throw new RuntimeException("Input file not found: /tmp/image.jpg");
            }
        }

        private void parallelComputation(Graphics g) {
            int w = this.image.getWidth();
            int s = this.image.getHeight();
            int size = w * s;
            IntArray imageRGB = new IntArray(w * s);
            long start = 0L;
            long end = 0L;
            long taskStart = 0L;
            long taskEnd = 0L;
            for (int z = 0; z < 15; ++z) {
                int i;
                start = System.nanoTime();
                for (i = 0; i < w; ++i) {
                    for (int j = 0; j < s; ++j) {
                        int rgb = this.image.getRGB(i, j);
                        imageRGB.set(i * s + j, rgb);
                    }
                }
                if (executor == null) {
                    workerGrid = new WorkerGrid2D(w, s);
                    gridScheduler = new GridScheduler("s0.t0", workerGrid);
                    KernelContext context = new KernelContext();
                    TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{imageRGB}).task("t0", LoadImage::compute2D, (Object)context, (Object)imageRGB, (Object)w, (Object)s).transferToHost(1, new Object[]{imageRGB});
                    ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
                    executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
                }
                workerGrid.setGlobalWork((long)w, (long)s, 1L);
                taskStart = System.nanoTime();
                executor.withGridScheduler(gridScheduler).execute();
                taskEnd = System.nanoTime();
                for (i = 0; i < w; ++i) {
                    for (int j = 0; j < s; ++j) {
                        this.image.setRGB(i, j, imageRGB.get(i * s + j));
                    }
                }
                end = System.nanoTime();
            }
            System.out.println("Total TornadoVM time: " + (end - start) + " (ns)");
            System.out.println("Task TornadoVM time: " + (taskEnd - taskStart) + " (ns)");
            g.drawImage(this.image, 0, 0, null);
            this.writeImage("parallel.jpg");
        }

        private void sequentialComputation(Graphics g) {
            int w = this.image.getWidth();
            int s = this.image.getHeight();
            long start = 0L;
            long end = 0L;
            for (int z = 0; z < 15; ++z) {
                start = System.nanoTime();
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < s; ++j) {
                        int rgb = this.image.getRGB(i, j);
                        int alpha = rgb >> 24 & 0xFF;
                        int red = rgb >> 16 & 0xFF;
                        int green = rgb >> 8 & 0xFF;
                        int blue = rgb & 0xFF;
                        int grayLevel = (red + green + blue) / 3;
                        int gray = alpha << 24 | grayLevel << 16 | grayLevel << 8 | grayLevel;
                        this.image.setRGB(i, j, gray);
                    }
                }
                end = System.nanoTime();
            }
            System.out.println("Total sequential time: " + (end - start) + " (ns)");
            g.drawImage(this.image, 0, 0, null);
            this.writeImage("sequential.jpg");
        }

        @Override
        public void paint(Graphics g) {
            if (PARALLEL_COMPUTATION) {
                this.parallelComputation(g);
            } else {
                this.sequentialComputation(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.image == null) {
                return new Dimension(100, 100);
            }
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
    }
}

