/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.flatmap;

import java.util.Random;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class FlatMapExample {
    private static final int SIZE = 16;

    private static void computeFlatMap(FloatArray input, FloatArray output, int size) {
        for (int i = 0; i < size; ++i) {
            if (!(input.get(i) > 100.0f)) continue;
            for (int j = 0; j < size; ++j) {
                output.set(i * size + j, input.get(i) + (float)j);
            }
        }
    }

    public static void main(String[] args) {
        FloatArray input = new FloatArray(256);
        FloatArray output = new FloatArray(256);
        Random r = new Random();
        IntStream.range(0, input.getSize()).forEach(i -> input.set(i, (float)(50 + r.nextInt(100))));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", FlatMapExample::computeFlatMap, (Object)input, (Object)output, (Object)16).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executorPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executorPlan.execute();
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j = 0; j < 16; ++j) {
                System.out.print(output.get(i2 * 16 + j) + " ");
            }
            System.out.println();
        }
    }
}

