/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.fft;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class TestFFT {
    public static void nesting(IntArray input, int dim, IntArray factors, int size, int dummyFac, IntArray dimArr) {
        for (int i = 0; i < dimArr.get(0); ++i) {
            for (int j = 0; j < dimArr.get(1); ++j) {
                int product = 1;
                boolean state = false;
                for (int z = 0; z < factors.getSize(); ++z) {
                    product *= input.get(z);
                    if (!state) {
                        state = true;
                        if (factors.get(z) != 2) continue;
                        int factor = 2;
                        int q = factors.get(z) / product;
                        int p_1 = product / factor;
                        for (int k = 0; k < q; ++k) {
                            for (int k1 = 0; k1 < p_1; ++k1) {
                                input.set(k1, i + j + z + k);
                            }
                        }
                        continue;
                    }
                    state = false;
                }
            }
        }
    }

    public static void nesting2(IntArray input, int dim, IntArray factors, int size, int dummyFac, IntArray dimArr) {
        int product = 1;
        int q = 1;
        int factor = 2;
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                input.set(j, i + j);
            }
            for (int z = 0; z < size; ++z) {
                int p_1 = (product *= input.get(z)) / factor;
                q = factors.get(z) == 2 ? (q += z) : (q += product);
                for (int k1 = 0; k1 < p_1; ++k1) {
                    input.set(k1, i + k1 + z + q);
                }
            }
        }
    }

    public static void main(String[] args) {
        IntArray input = new IntArray(2);
        IntArray factors = new IntArray(2);
        input.set(0, 4);
        factors.set(0, 2);
        input.set(1, 4);
        factors.set(1, 2);
        int dim = 2;
        IntArray dimArr = new IntArray(3);
        dimArr.init(2);
        int size = factors.getSize();
        int dummyFac = 2;
        IntArray seq = new IntArray(2);
        seq.set(0, input.get(0));
        seq.set(1, input.get(1));
        TaskGraph taskGraph = new TaskGraph("x0").transferToDevice(0, new Object[]{factors, dimArr}).task("t0", TestFFT::nesting, (Object)input, (Object)dim, (Object)factors, (Object)size, (Object)dummyFac, (Object)dimArr).transferToHost(1, new Object[]{input});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executorPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executorPlan.execute();
        TestFFT.nesting(seq, dim, factors, size, dummyFac, dimArr);
        System.out.println("Tornado Output = " + String.valueOf(input));
        System.out.println("Seq Output     = " + String.valueOf(seq));
        boolean equals = true;
        for (int i = 0; i < input.getSize(); ++i) {
            if (input.get(i) == seq.get(i)) continue;
            equals = false;
            break;
        }
        if (equals) {
            System.out.println("Result is correct");
        } else {
            System.out.println("Result is wrong");
        }
    }
}

