/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.compute;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class MonteCarlo {
    private static void computeMontecarlo(FloatArray output, int iterations) {
        for (int j = 0; j < iterations; ++j) {
            long seed = j;
            seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            float x = (float)(seed & 0xFFFFFFFL) / 2.6843546E8f;
            seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            float y = (float)((seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) & 0xFFFFFFFL) / 2.6843546E8f;
            float dist = (float)Math.sqrt(x * x + y * y);
            if (dist <= 1.0f) {
                output.set(j, 1.0f);
                continue;
            }
            output.set(j, 0.0f);
        }
    }

    public static void montecarlo(int size) {
        FloatArray output = new FloatArray(size);
        FloatArray seq = new FloatArray(size);
        TaskGraph taskGraph = new TaskGraph("s0").task("taskGraph", MonteCarlo::computeMontecarlo, (Object)output, (Object)size).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        long start = System.nanoTime();
        executor.execute();
        long end = System.nanoTime();
        long tornadoTime = end - start;
        float sum = 0.0f;
        for (int j = 0; j < size; ++j) {
            sum += output.get(j);
        }
        System.out.println("Total time (Tornado)   : " + tornadoTime);
        System.out.println("Pi value(Tornado)   : " + (sum *= 4.0f) / (float)size);
        start = System.nanoTime();
        MonteCarlo.computeMontecarlo(seq, size);
        end = System.nanoTime();
        long sequentialTime = end - start;
        sum = 0.0f;
        for (int j = 0; j < size; ++j) {
            sum += seq.get(j);
        }
        System.out.println("Total time (Sequential): " + sequentialTime);
        System.out.println("Pi value(seq)   : " + (sum *= 4.0f) / (float)size);
        double speedup = (double)sequentialTime / (double)tornadoTime;
        System.out.println("Speedup: " + speedup);
    }

    public static void main(String[] args) {
        System.out.println("Compute Montecarlo");
        MonteCarlo.montecarlo(0x1000000);
    }
}

