/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.compute;

import java.util.ArrayList;
import java.util.LongSummaryStatistics;
import java.util.Random;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat;

public class MatrixVector {
    public static final int WARM_UP_ITERATIONS = 100;
    public static final int MAX_ITERATIONS = 100;

    private static void computeMatrixVector(Matrix2DFloat matrix, VectorFloat vector, VectorFloat output) {
        for (int i = 0; i < matrix.getNumRows(); ++i) {
            float sum = 0.0f;
            for (int j = 0; j < matrix.getNumColumns(); ++j) {
                sum += matrix.get(i, j) * vector.get(j);
            }
            output.set(i, sum);
        }
    }

    public static void main(String[] args) {
        long end;
        long start;
        int i;
        int size = 8192;
        if (args.length >= 1) {
            try {
                size = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                throw new NullPointerException();
            }
        }
        Matrix2DFloat matrix2DFloat = new Matrix2DFloat(size, size);
        VectorFloat vectorFloat = new VectorFloat(size);
        VectorFloat result = new VectorFloat(size);
        VectorFloat resultSeq = new VectorFloat(size);
        Random r = new Random();
        ArrayList<Long> seqTimers = new ArrayList<Long>();
        ArrayList<Long> tornadoTimers = new ArrayList<Long>();
        int s = size;
        IntStream.range(0, size).forEach(idx -> vectorFloat.set(idx, r.nextFloat()));
        IntStream.range(0, size).forEach(idx -> IntStream.range(0, s).forEach(jdx -> matrix2DFloat.set(idx, jdx, r.nextFloat())));
        TaskGraph taskGraph = new TaskGraph("la").transferToDevice(0, new Object[]{vectorFloat, matrix2DFloat}).task("mv", MatrixVector::computeMatrixVector, (Object)matrix2DFloat, (Object)vectorFloat, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withPreCompilation();
        for (i = 0; i < 100; ++i) {
            MatrixVector.computeMatrixVector(matrix2DFloat, vectorFloat, resultSeq);
        }
        for (i = 0; i < 100; ++i) {
            start = System.nanoTime();
            MatrixVector.computeMatrixVector(matrix2DFloat, vectorFloat, resultSeq);
            end = System.nanoTime();
            seqTimers.add(end - start);
            System.out.println("SEQ-TIME: " + (end - start));
        }
        for (i = 0; i < 100; ++i) {
            executor.execute();
        }
        for (i = 0; i < 100; ++i) {
            start = System.nanoTime();
            executor.execute();
            end = System.nanoTime();
            tornadoTimers.add(end - start);
            System.out.println("PARALLEL-TIME: " + (end - start));
        }
        LongSummaryStatistics statsSeq = seqTimers.stream().mapToLong(Long::longValue).summaryStatistics();
        LongSummaryStatistics statsTornado = tornadoTimers.stream().mapToLong(Long::longValue).summaryStatistics();
        System.out.println("SEQ    : " + statsSeq.getAverage());
        System.out.println("Tornado: " + statsTornado.getAverage());
        System.out.println("SPEEDUP: " + statsSeq.getAverage() / statsTornado.getAverage());
    }
}

