/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.compute;

import java.util.Random;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class MatrixMultiplication1D {
    private static final int WARMING_UP_ITERATIONS = 15;

    private static void matrixMultiplication(FloatArray matrixA, FloatArray matrixB, FloatArray result, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < size; ++k) {
                    sum += matrixA.get(i * size + k) * matrixB.get(k * size + j);
                }
                result.set(i * size + j, sum);
            }
        }
    }

    public static void main(String[] args) throws NumberFormatException {
        int size = 512;
        if (args.length >= 1) {
            size = Integer.parseInt(args[0]);
        }
        System.out.println("Computing MxM of " + size + "x" + size);
        FloatArray matrixA = new FloatArray(size * size);
        FloatArray matrixB = new FloatArray(size * size);
        FloatArray matrixC = new FloatArray(size * size);
        FloatArray resultSeq = new FloatArray(size * size);
        Random r = new Random();
        IntStream.range(0, size * size).forEach(idx -> {
            matrixA.set(idx, r.nextFloat());
            matrixB.set(idx, r.nextFloat());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("t0", MatrixMultiplication1D::matrixMultiplication, (Object)matrixA, (Object)matrixB, (Object)matrixC, (Object)size).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withPreCompilation();
        for (int i = 0; i < 15; ++i) {
            executor.execute();
        }
        long start = System.currentTimeMillis();
        executor.execute();
        long end = System.currentTimeMillis();
        for (int i = 0; i < 15; ++i) {
            MatrixMultiplication1D.matrixMultiplication(matrixA, matrixB, resultSeq, size);
        }
        long startSequential = System.currentTimeMillis();
        MatrixMultiplication1D.matrixMultiplication(matrixA, matrixB, resultSeq, size);
        long endSequential = System.currentTimeMillis();
        long msecGPUElapsedTime = end - start;
        long msecCPUElaptedTime = endSequential - startSequential;
        double flops = 2.0 * Math.pow(size, 3.0);
        double gpuGigaFlops = 1.0E-9 * flops / (double)((float)msecGPUElapsedTime / 1000.0f);
        double cpuGigaFlops = 1.0E-9 * flops / (double)((float)msecCPUElaptedTime / 1000.0f);
        double speedup = (double)(endSequential - startSequential) / (double)(end - start);
        String formatGPUFGlops = String.format("%.2f", gpuGigaFlops);
        String formatCPUFGlops = String.format("%.2f", cpuGigaFlops);
        TornadoDeviceType deviceType = executor.getDevice(0).getDeviceType();
        String buffer = "\tSingle Threaded CPU Execution: " + formatCPUFGlops + " GFlops, Total time = " + (endSequential - startSequential) + " ms\n\tTornadoVM Execution on " + String.valueOf(deviceType) + " (Accelerated): " + formatGPUFGlops + " GFlops, Total Time = " + (end - start) + " ms\n\tSpeedup: " + speedup + "x\n\tVerification " + MatrixMultiplication1D.verify(matrixC, resultSeq, size) + "\n";
        System.out.println(buffer);
    }

    private static boolean verify(FloatArray par, FloatArray seq, int size) {
        boolean check = true;
        block0: for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (!(Math.abs(par.get(i * size + j) - seq.get(i * size + j)) > 0.1f)) continue;
                check = false;
                continue block0;
            }
        }
        return check;
    }
}

