/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.compute;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class BlackScholes {
    private static final int WARM_UP_ITERATIONS = 1000;

    private static void blackScholesKernel(FloatArray input, FloatArray callResult, FloatArray putResult) {
        for (int idx = 0; idx < callResult.getSize(); ++idx) {
            float rand = input.get(idx);
            float S_LOWER_LIMIT = 10.0f;
            float S_UPPER_LIMIT = 100.0f;
            float K_LOWER_LIMIT = 10.0f;
            float K_UPPER_LIMIT = 100.0f;
            float T_LOWER_LIMIT = 1.0f;
            float T_UPPER_LIMIT = 10.0f;
            float R_LOWER_LIMIT = 0.01f;
            float R_UPPER_LIMIT = 0.05f;
            float SIGMA_LOWER_LIMIT = 0.01f;
            float SIGMA_UPPER_LIMIT = 0.1f;
            float S = 10.0f * rand + 100.0f * (1.0f - rand);
            float K = 10.0f * rand + 100.0f * (1.0f - rand);
            float T = 1.0f * rand + 10.0f * (1.0f - rand);
            float r = 0.01f * rand + 0.05f * (1.0f - rand);
            float v = 0.01f * rand + 0.1f * (1.0f - rand);
            float d1 = (TornadoMath.log((float)(S / K)) + (r + v * v / 2.0f) * T) / v * TornadoMath.sqrt((float)T);
            float d2 = d1 - v * TornadoMath.sqrt((float)T);
            callResult.set(idx, S * BlackScholes.cnd(d1) - K * TornadoMath.exp((float)(T * -1.0f * r)) * BlackScholes.cnd(d2));
            putResult.set(idx, K * TornadoMath.exp((float)(T * -r)) * BlackScholes.cnd(-d2) - S * BlackScholes.cnd(-d1));
        }
    }

    private static float cnd(float X) {
        float c1 = 0.31938154f;
        float c2 = -0.35656378f;
        float c3 = 1.7814779f;
        float c4 = -1.8212559f;
        float c5 = 1.3302745f;
        float zero = 0.0f;
        float one = 1.0f;
        float two = 2.0f;
        float temp4 = 0.2316419f;
        float oneBySqrt2pi = 0.3989423f;
        float absX = TornadoMath.abs((float)X);
        float t = 1.0f / (1.0f + 0.2316419f * absX);
        float y = 1.0f - 0.3989423f * TornadoMath.exp((float)(-X * X / 2.0f)) * t * (0.31938154f + t * (-0.35656378f + t * (1.7814779f + t * (-1.8212559f + t * 1.3302745f))));
        return X < 0.0f ? 1.0f - y : y;
    }

    private static boolean checkResult(FloatArray call, FloatArray put, FloatArray callPrice, FloatArray putPrice) {
        double delta = 1.8;
        for (int i = 0; i < call.getSize(); ++i) {
            if ((double)Math.abs(call.get(i) - callPrice.get(i)) > delta) {
                System.out.println("call: " + call.get(i) + " vs gpu " + callPrice.get(i));
                return false;
            }
            if (!((double)Math.abs(put.get(i) - putPrice.get(i)) > delta)) continue;
            System.out.println("put: " + put.get(i) + " vs gpu " + putPrice.get(i));
            return false;
        }
        return true;
    }

    public static void blackScholes(int size) {
        Random random = new Random();
        FloatArray input = new FloatArray(size);
        FloatArray callPrice = new FloatArray(size);
        FloatArray putPrice = new FloatArray(size);
        FloatArray seqCall = new FloatArray(size);
        FloatArray seqPut = new FloatArray(size);
        for (int i = 0; i < size; ++i) {
            input.set(i, random.nextFloat());
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", BlackScholes::blackScholesKernel, (Object)input, (Object)callPrice, (Object)putPrice).transferToHost(1, new Object[]{callPrice, putPrice});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        for (int i = 0; i < 1000; ++i) {
            executor.execute();
        }
        long start = System.nanoTime();
        executor.execute();
        long end = System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            BlackScholes.blackScholesKernel(input, seqCall, seqPut);
        }
        long start2 = System.nanoTime();
        BlackScholes.blackScholesKernel(input, seqCall, seqPut);
        long end2 = System.nanoTime();
        boolean results = BlackScholes.checkResult(seqCall, seqPut, callPrice, putPrice);
        System.out.println("Validation " + results + " \n");
        System.out.println("Seq     : " + (end2 - start2) + " (ns)");
        System.out.println("Parallel: " + (end - start) + " (ns)");
        System.out.println("Speedup : " + (end2 - start2) / (end - start) + "x");
    }

    public static void main(String[] args) {
        System.out.println("BlackScholes TornadoVM");
        int size = 1024;
        if (args.length > 0) {
            try {
                size = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println("Input size: " + size + " \n");
        BlackScholes.blackScholes(size);
    }
}

