/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.compute;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class BlackAndWhiteTransform {
    public static void main(String[] args) {
        JFrame frame = new JFrame("Image Grey-scale conversion example with TornadoVM");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        frame.add(new LoadImage());
        frame.pack();
        frame.setVisible(true);
    }

    public static class LoadImage
    extends Component {
        private static final int WARMING_UP_ITERATIONS = 15;
        private static final long serialVersionUID = 1L;
        private static final boolean PARALLEL_COMPUTATION = Boolean.parseBoolean(System.getProperty("run::parallel", "False"));
        private static final String IMAGE_FILE = "/tmp/image.jpg";
        private static TaskGraph taskGraph;
        private static TornadoExecutionPlan executor;
        private BufferedImage image;

        LoadImage() {
            try {
                this.image = ImageIO.read(new File(IMAGE_FILE));
            }
            catch (IOException e) {
                throw new RuntimeException("Input file not found: /tmp/image.jpg");
            }
        }

        private static void compute(IntArray image, int w, int s) {
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < s; ++j) {
                    int rgb = image.get(i * s + j);
                    int alpha = rgb >> 24 & 0xFF;
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    int grayLevel = (red + green + blue) / 3;
                    int gray = alpha << 24 | grayLevel << 16 | grayLevel << 8 | grayLevel;
                    image.set(i * s + j, gray);
                }
            }
        }

        private void writeImage(String fileName) {
            try {
                ImageIO.write((RenderedImage)this.image, "jpg", new File("/tmp/" + fileName));
            }
            catch (IOException e) {
                throw new RuntimeException("Input file not found: /tmp/image.jpg");
            }
        }

        private void parallelComputation(Graphics g) {
            int w = this.image.getWidth();
            int s = this.image.getHeight();
            IntArray imageRGB = new IntArray(w * s);
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < s; ++j) {
                    int rgb = this.image.getRGB(i, j);
                    imageRGB.set(i * s + j, rgb);
                }
            }
            if (executor == null) {
                taskGraph = new TaskGraph("s0");
                taskGraph.transferToDevice(1, new Object[]{imageRGB}).task("t0", LoadImage::compute, (Object)imageRGB, (Object)w, (Object)s).transferToHost(1, new Object[]{imageRGB});
                ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
                executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            }
            for (int z = 0; z < 15; ++z) {
                long start = System.nanoTime();
                executor.execute();
                long end = System.nanoTime();
                System.out.println("Total TornadoVM time: " + (end - start) + " (ns)");
            }
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < s; ++j) {
                    this.image.setRGB(i, j, imageRGB.get(i * s + j));
                }
            }
            g.drawImage(this.image, 0, 0, null);
            this.writeImage("parallel.jpg");
        }

        private void sequentialComputation(Graphics g) {
            int w = this.image.getWidth();
            int s = this.image.getHeight();
            long start = 0L;
            long end = 0L;
            for (int z = 0; z < 15; ++z) {
                start = System.nanoTime();
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < s; ++j) {
                        int rgb = this.image.getRGB(i, j);
                        int alpha = rgb >> 24 & 0xFF;
                        int red = rgb >> 16 & 0xFF;
                        int green = rgb >> 8 & 0xFF;
                        int blue = rgb & 0xFF;
                        int grayLevel = (red + green + blue) / 3;
                        int gray = alpha << 24 | grayLevel << 16 | grayLevel << 8 | grayLevel;
                        this.image.setRGB(i, j, gray);
                    }
                }
                end = System.nanoTime();
                System.out.println("Total sequential time: " + (end - start) + " (ns)");
            }
            g.drawImage(this.image, 0, 0, null);
            this.writeImage("sequential.jpg");
        }

        @Override
        public void paint(Graphics g) {
            if (PARALLEL_COMPUTATION) {
                this.parallelComputation(g);
            } else {
                this.sequentialComputation(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.image == null) {
                return new Dimension(100, 100);
            }
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
    }
}

