/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.compute;

import java.util.Random;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class BFS {
    public static final boolean SAMPLE = false;
    private static final boolean BIDIRECTIONAL = false;
    private static final boolean PRINT_SOLUTION = false;
    private static final boolean VALIDATION = true;
    IntArray vertices;
    IntArray verticesJava;
    IntArray adjacencyMatrix;
    IntArray modify;
    IntArray modifyJava;
    IntArray currentDepth;

    public static void connect(int from, int to, IntArray graph, int N) {
        if (from != to && graph.get(from * N + to) == 0) {
            graph.set(from * N + to, 1);
        }
    }

    public static void initializeAdjacencyMatrixSimpleGraph(IntArray adjacencyMatrix, int numNodes) {
        adjacencyMatrix.init(0);
        BFS.connect(0, 1, adjacencyMatrix, numNodes);
        BFS.connect(0, 4, adjacencyMatrix, numNodes);
        BFS.connect(1, 2, adjacencyMatrix, numNodes);
        BFS.connect(2, 3, adjacencyMatrix, numNodes);
        BFS.connect(2, 4, adjacencyMatrix, numNodes);
        BFS.connect(3, 4, adjacencyMatrix, numNodes);
    }

    private static int[] generateIntRandomArray(int numNodes) {
        Random r = new Random();
        int bound = r.nextInt(numNodes);
        IntStream streamArray = r.ints(bound, 0, numNodes);
        int[] array = streamArray.toArray();
        return array;
    }

    public static void generateRandomGraph(IntArray adjacencyMatrix, int numNodes, int root) {
        Random r = new Random();
        int bound = r.nextInt(numNodes);
        IntStream fromStream = r.ints(bound, 0, numNodes);
        int[] f = fromStream.toArray();
        for (int k = 0; k < f.length; ++k) {
            int from = f[k];
            if (k == 0) {
                from = root;
            }
            int[] toArray = BFS.generateIntRandomArray(numNodes);
            for (int i = 0; i < toArray.length; ++i) {
                BFS.connect(from, toArray[i], adjacencyMatrix, numNodes);
            }
        }
    }

    private static void initializeVertices(int numNodes, IntArray vertices, int root) {
        for (int i = 0; i < numNodes; ++i) {
            if (i == root) {
                vertices.set(i, 0);
                continue;
            }
            vertices.set(i, -1);
        }
    }

    private static void runBFS(IntArray vertices, IntArray adjacencyMatrix, int numNodes, IntArray h_true, IntArray currentDepth) {
        for (int from = 0; from < numNodes; ++from) {
            for (int to = 0; to < numNodes; ++to) {
                int elementAccess = from * numNodes + to;
                if (adjacencyMatrix.get(elementAccess) != 1) continue;
                int dfirst = vertices.get(from);
                int dsecond = vertices.get(to);
                if (currentDepth.get(0) != dfirst || dsecond != -1) continue;
                vertices.set(to, dfirst + 1);
                h_true.set(0, 0);
            }
        }
    }

    public static void main(String[] args) {
        int size = 10000;
        new BFS().tornadoBFS(0, size);
    }

    public boolean validateBFS(IntArray vertices, IntArray verticesJava) {
        boolean check = true;
        for (int i = 0; i < vertices.getSize(); ++i) {
            if (vertices.get(i) == verticesJava.get(i)) continue;
            check = false;
        }
        return check;
    }

    public boolean checkModify(IntArray modify, IntArray modifyJava) {
        boolean check = true;
        for (int i = 0; i < modify.getSize(); ++i) {
            if (modify.get(i) == modifyJava.get(i)) continue;
            check = false;
        }
        return check;
    }

    public void tornadoBFS(int rootNode, int numNodes) {
        this.vertices = new IntArray(numNodes);
        this.verticesJava = new IntArray(numNodes);
        this.adjacencyMatrix = new IntArray(numNodes * numNodes);
        boolean validModifyResults = true;
        BFS.generateRandomGraph(this.adjacencyMatrix, numNodes, rootNode);
        BFS.initializeVertices(numNodes, this.vertices, rootNode);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", BFS::initializeVertices, (Object)numNodes, (Object)this.vertices, (Object)rootNode).transferToHost(1, new Object[]{this.vertices});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        BFS.initializeVertices(numNodes, this.verticesJava, rootNode);
        this.modify = new IntArray(1);
        this.modify.init(1);
        this.modifyJava = new IntArray(1);
        this.modifyJava.init(1);
        this.currentDepth = new IntArray(1);
        this.currentDepth.init(0);
        TornadoDevice device = TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice();
        TaskGraph taskGraph1 = new TaskGraph("s1").transferToDevice(1, new Object[]{this.vertices, this.adjacencyMatrix, this.modify, this.currentDepth}).task("t1", BFS::runBFS, (Object)this.vertices, (Object)this.adjacencyMatrix, (Object)numNodes, (Object)this.modify, (Object)this.currentDepth).transferToHost(1, new Object[]{this.vertices, this.modify});
        ImmutableTaskGraph immutableTaskGraph1 = taskGraph1.snapshot();
        TornadoExecutionPlan executor1 = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph1}).withDevice(device);
        boolean done = false;
        while (!done) {
            boolean allDone = true;
            System.out.println("Current Depth: " + this.currentDepth.get(0));
            BFS.runBFS(this.verticesJava, this.adjacencyMatrix, numNodes, this.modifyJava, this.currentDepth);
            executor1.execute();
            this.currentDepth.set(0, this.currentDepth.get(0) + 1);
            validModifyResults = this.checkModify(this.modify, this.modifyJava);
            if (!validModifyResults) break;
            for (int i = 0; i < this.modify.getSize(); ++i) {
                if (this.modify.get(i) != 0) continue;
                allDone = false;
                break;
            }
            if (allDone) {
                done = true;
            }
            this.modify.init(1);
            this.modifyJava.init(1);
        }
        if (this.validateBFS(this.vertices, this.verticesJava) && validModifyResults) {
            System.out.println("Validation true");
        } else {
            System.out.println("Validation false");
        }
    }
}

