/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.arrays;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

public class TornadoNativeArrayInit {
    private static void benchmarkRegularConstructor(int size, int iterations) {
        System.out.println("Benchmarking Regular Constructor...");
        long startTime = System.nanoTime();
        for (int iter = 0; iter < iterations; ++iter) {
            FloatArray array = new FloatArray(size);
            for (int i = 0; i < size; ++i) {
                array.set(i, (float)i * 1.5f);
            }
            float sum = 0.0f;
            for (int i = 0; i < Math.min(10, size); ++i) {
                sum += array.get(i);
            }
        }
        long duration = System.nanoTime() - startTime;
        double ms = (double)duration / 1000000.0;
        System.out.printf("Regular Constructor: %.3f ms for %d iterations\n", ms, iterations);
    }

    private static void benchmarkFromSegment(int size, int iterations) {
        System.out.println("Benchmarking fromSegment Method...");
        MemorySegment dataSegment = Arena.ofAuto().allocate(ValueLayout.JAVA_FLOAT.byteSize() * (long)size);
        for (int i = 0; i < size; ++i) {
            dataSegment.setAtIndex(ValueLayout.JAVA_FLOAT, (long)i, (float)i * 1.5f);
        }
        long startTime = System.nanoTime();
        for (int iter = 0; iter < iterations; ++iter) {
            FloatArray array = FloatArray.fromSegment((MemorySegment)dataSegment);
            float sum = 0.0f;
            for (int i = 0; i < Math.min(10, size); ++i) {
                sum += array.get(i);
            }
        }
        long duration = System.nanoTime() - startTime;
        double ms = (double)duration / 1000000.0;
        System.out.printf("fromSegment Method: %.3f ms for %d iterations\n", ms, iterations);
    }

    private static void benchmarkFromSegmentShallow(int size, int iterations) {
        System.out.println("Benchmarking fromSegmentShallow Method...");
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long totalSize = headerSize + ValueLayout.JAVA_FLOAT.byteSize() * (long)size;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffsetInFloats = headerSize / ValueLayout.JAVA_FLOAT.byteSize();
        for (int i = 0; i < size; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_FLOAT, headerOffsetInFloats + (long)i, (float)i * 1.5f);
        }
        long startTime = System.nanoTime();
        for (int iter = 0; iter < iterations; ++iter) {
            FloatArray array = FloatArray.fromSegmentShallow((MemorySegment)segment);
            float sum = 0.0f;
            for (int i = 0; i < Math.min(10, size); ++i) {
                sum += array.get(i);
            }
        }
        long duration = System.nanoTime() - startTime;
        double ms = (double)duration / 1000000.0;
        System.out.printf("fromSegmentShallow Method: %.3f ms for %d iterations\n", ms, iterations);
    }

    private static String formatArraySize(int elements) {
        long bytes = (long)elements * ValueLayout.JAVA_FLOAT.byteSize();
        if (bytes >= 0x40000000L) {
            return String.format("%.2f GB", (double)bytes / 1.073741824E9);
        }
        if (bytes >= 0x100000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        if (bytes >= 1024L) {
            return String.format("%.2f KB", (double)bytes / 1024.0);
        }
        return bytes + " bytes";
    }

    public static void main(String[] args) {
        System.out.println("TornadoVM Native Array Initialization Performance Benchmark");
        System.out.println("Testing FloatArray initialization methods\n");
        int[] sizes = new int[]{1000, 10000, 100000, 1000000};
        int iterations = 100;
        for (int size : sizes) {
            System.out.println("=".repeat(80));
            System.out.printf("Performance Benchmark - Array Size: %,d elements (%s), Iterations: %,d\n", size, TornadoNativeArrayInit.formatArraySize(size), iterations);
            System.out.printf("Header Size: %d bytes\n", TornadoNativeArray.ARRAY_HEADER);
            System.out.println("=".repeat(80));
            System.out.println("Warming up JVM...");
            for (int i = 0; i < 10; ++i) {
                FloatArray warmup = new FloatArray(100);
                warmup.set(0, 1.0f);
            }
            long[] times = new long[3];
            long startTime = System.nanoTime();
            TornadoNativeArrayInit.benchmarkRegularConstructor(size, iterations);
            times[0] = System.nanoTime() - startTime;
            startTime = System.nanoTime();
            TornadoNativeArrayInit.benchmarkFromSegment(size, iterations);
            times[1] = System.nanoTime() - startTime;
            startTime = System.nanoTime();
            TornadoNativeArrayInit.benchmarkFromSegmentShallow(size, iterations);
            times[2] = System.nanoTime() - startTime;
            double regularMs = (double)times[0] / 1000000.0;
            double fromSegmentMs = (double)times[1] / 1000000.0;
            double fromSegmentShallowMs = (double)times[2] / 1000000.0;
            double speedupVsRegular = regularMs / fromSegmentShallowMs;
            double speedupVsFromSegment = fromSegmentMs / fromSegmentShallowMs;
            System.out.println("\n" + "-".repeat(60));
            System.out.println("PERFORMANCE SUMMARY:");
            System.out.println("-".repeat(60));
            System.out.printf("Regular Constructor:    %.3f ms\n", regularMs);
            System.out.printf("fromSegment Method:     %.3f ms\n", fromSegmentMs);
            System.out.printf("fromSegmentShallow Method:  %.3f ms\n", fromSegmentShallowMs);
            System.out.println("-".repeat(60));
            System.out.printf("fromSegmentShallow vs Regular:      %.2fx faster\n", speedupVsRegular);
            System.out.printf("fromSegmentShallow vs fromSegment:  %.2fx faster\n", speedupVsFromSegment);
            System.out.println("-".repeat(60));
        }
    }
}

