/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.arrays;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class ArrayMultiplyAdd {
    public static void main(String[] args) {
        int numElements = args.length == 1 ? Integer.parseInt(args[0]) : 1024;
        FloatArray a = new FloatArray(numElements);
        FloatArray b = new FloatArray(numElements);
        FloatArray c = new FloatArray(numElements);
        FloatArray d = new FloatArray(numElements);
        a.init(3.0f);
        b.init(2.0f);
        c.init(0.0f);
        d.init(0.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b, c}).task("t0", (a2, b2, c2) -> {
            for (int i = 0; i < a2.getSize(); ++i) {
                c2.set(i, a2.get(i) * b2.get(i));
            }
        }, (Object)a, (Object)b, (Object)c).task("t1", (a1, b1, c1) -> {
            for (int i = 0; i < a1.getSize(); ++i) {
                c1.set(i, a1.get(i) + b1.get(i));
            }
        }, (Object)c, (Object)b, (Object)d).transferToHost(1, new Object[]{d});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        for (int i = 0; i < numElements; ++i) {
            float value = d.get(i);
            if (value == 8.0f) continue;
            System.out.println("Invalid result: " + value);
            break;
        }
    }
}

