/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.arrays;

import uk.ac.manchester.tornado.api.AccessorParameters;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class ArrayAddIntPrebuilt {
    public static void add(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void main(String[] args) {
        int numElements = 8;
        IntArray a = new IntArray(8);
        IntArray b = new IntArray(8);
        IntArray c = new IntArray(8);
        a.init(1);
        b.init(2);
        c.init(0);
        String tornadoSDK = System.getenv("TORNADOVM_HOME");
        TornadoDevice device = TornadoRuntimeProvider.getTornadoRuntime().getDefaultDevice();
        String filePath = tornadoSDK + "/examples/generated/";
        filePath = filePath + (device.getPlatformName().contains("PTX") ? "add.ptx" : "add.cl");
        AccessorParameters accessorParameters = new AccessorParameters(3);
        accessorParameters.set(0, (Object)a, Access.READ_ONLY);
        accessorParameters.set(1, (Object)b, Access.READ_ONLY);
        accessorParameters.set(2, (Object)c, Access.WRITE_ONLY);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).prebuiltTask("t0", "add", filePath, accessorParameters).transferToHost(1, new Object[]{c});
        WorkerGrid1D workerGrid = new WorkerGrid1D(8);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        try (TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executor.withDevice(device).withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoExecutionPlanException e) {
            e.printStackTrace();
        }
    }
}

