/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.arrays;

import java.util.Arrays;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class ArrayAddInt {
    public static void add(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void main(String[] args) throws TornadoExecutionPlanException {
        int numElements = 8;
        IntArray a = new IntArray(8);
        IntArray b = new IntArray(8);
        IntArray c = new IntArray(8);
        a.init(1);
        b.init(2);
        c.init(0);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", ArrayAddInt::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executor.execute();
        }
        System.out.println("a: " + Arrays.toString(a.toHeapArray()));
        System.out.println("b: " + Arrays.toString(b.toHeapArray()));
        System.out.println("c: " + Arrays.toString(c.toHeapArray()));
    }
}

