/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.arrays;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;

public class ArrayAddDouble {
    public static void add(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void main(String[] args) {
        int numElements = 8;
        DoubleArray a = new DoubleArray(8);
        DoubleArray b = new DoubleArray(8);
        DoubleArray c = new DoubleArray(8);
        a.init(1.0);
        b.init(2.0);
        c.init(0.0);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", ArrayAddDouble::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        System.out.println("a: " + String.valueOf(a));
        System.out.println("b: " + String.valueOf(b));
        System.out.println("c: " + String.valueOf(c));
    }
}

