/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples.arrays;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class ArrayAccInt {
    public static void acc(IntArray a, int value) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) + value);
        }
    }

    public static void main(String[] args) {
        int numElements = 8;
        int numKernels = 8;
        IntArray a = new IntArray(8);
        a.init(10);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.transferToDevice(0, new Object[]{a});
        for (int i = 0; i < 8; ++i) {
            taskGraph.task("t" + i, ArrayAccInt::acc, (Object)a, (Object)1);
        }
        taskGraph.transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        System.out.println("a: " + String.valueOf(a));
    }
}

