/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class VectorAddInt {
    private static void vectorAdd(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        IntArray a = new IntArray(size);
        IntArray b = new IntArray(size);
        IntArray c = new IntArray(size);
        IntArray result = new IntArray(size);
        a.init(10);
        b.init(20);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", VectorAddInt::vectorAdd, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan tornadoExecutor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        String profileLog = null;
        for (int idx = 0; idx < 10; ++idx) {
            TornadoExecutionResult executionResult = tornadoExecutor.execute();
            VectorAddInt.vectorAdd(a, b, result);
            boolean wrongResult = false;
            for (int i = 0; i < c.getSize(); ++i) {
                if (c.get(i) == 30) continue;
                wrongResult = true;
                break;
            }
            if (wrongResult) {
                System.out.println("Result is wrong");
            } else {
                System.out.println("Result is correct. Total time: " + executionResult.getProfilerResult().getTotalTime() + " (ns)");
            }
            profileLog = executionResult.getProfilerResult().getProfileLog();
        }
        System.out.println(profileLog);
    }
}

