/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples;

import java.util.Random;
import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class MultipleTasks {
    private static final int MAX_ITERATIONS = 100;

    private static void foo(FloatArray x, FloatArray y) {
        for (int i = 0; i < y.getSize(); ++i) {
            y.set(i, x.get(i) + 100.0f);
        }
    }

    private static void bar(FloatArray y) {
        for (int i = 0; i < y.getSize(); ++i) {
            y.set(i, y.get(i) + 200.0f);
        }
    }

    public static void main(String[] args) {
        int numElements = 512;
        if (args.length > 0) {
            numElements = Integer.parseInt(args[0]);
        }
        FloatArray x = new FloatArray(numElements);
        FloatArray y = new FloatArray(numElements);
        Random r = new Random();
        IntStream.range(0, numElements).parallel().forEach(i -> x.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("example").transferToDevice(1, new Object[]{x}).task("foo", MultipleTasks::foo, (Object)x, (Object)y).task("bar", MultipleTasks::bar, (Object)y).transferToHost(1, new Object[]{y});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        for (int i2 = 0; i2 < 100; ++i2) {
            executor.execute();
        }
    }
}

