/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.examples;

import java.math.BigDecimal;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;

public class Init {
    private static final boolean CHECK = true;

    public static void compute(FloatArray array) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, array.get(i) + 100.0f);
        }
    }

    public static void main(String[] args) {
        int size = 300000000;
        if (args.length > 0) {
            size = Integer.parseInt(args[0]);
        }
        BigDecimal bytesToAllocate = new BigDecimal((float)((long)size * 4L) * 1.0E-6f);
        System.out.println("Running with size: " + size);
        System.out.println("Input size: " + String.valueOf(bytesToAllocate) + " (MB)");
        FloatArray array = new FloatArray(size);
        TornadoDevice device = TornadoRuntimeProvider.getTornadoRuntime().getBackend(0).getDevice(0);
        long maxDeviceMemory = device.getMaxAllocMemory();
        double mb = (double)maxDeviceMemory * 1.0E-6;
        System.out.println("Maximum alloc device memory: " + mb + " (MB)");
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", Init::compute, (Object)array).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.execute();
        boolean check = true;
        for (int i = 0; i < array.getSize(); ++i) {
            if (array.get(i) == 100.0f) continue;
            check = false;
            break;
        }
        if (!check) {
            System.out.println("Result is wrong");
        } else {
            System.out.println("Result is correct");
        }
    }
}

