/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.virtual;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.api.memory.TornadoMemoryProvider;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLProviders;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompiler;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualOCLDevice;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.KernelStackFrame;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoInstalledCode;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoSchedulingStrategy;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;
import uk.ac.manchester.tornado.runtime.sketcher.Sketch;
import uk.ac.manchester.tornado.runtime.sketcher.TornadoSketcher;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;
import uk.ac.manchester.tornado.runtime.tasks.PrebuiltTask;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class VirtualOCLTornadoDevice
implements TornadoXPUDevice {
    private static OCLBackendImpl driver = null;
    private final OCLTargetDevice device;
    private final int deviceIndex;
    private final int platformIndex;
    private final String platformName;

    public VirtualOCLTornadoDevice(int platformIndex, int deviceIndex) {
        this.platformIndex = platformIndex;
        this.deviceIndex = deviceIndex;
        this.platformName = VirtualOCLTornadoDevice.findDriver().getPlatformContext(platformIndex).getPlatform().getName();
        this.device = VirtualOCLTornadoDevice.findDriver().getPlatformContext(platformIndex).devices().get(deviceIndex);
    }

    private static OCLBackendImpl findDriver() {
        if (driver == null) {
            driver = (OCLBackendImpl)TornadoCoreRuntime.getTornadoRuntime().getBackend(OCLBackendImpl.class);
            TornadoInternalError.guarantee((driver != null ? 1 : 0) != 0, (String)"unable to find OpenCL driver", (Object[])new Object[0]);
        }
        return driver;
    }

    public void dumpEvents(long executionPlanId) {
    }

    public String getDescription() {
        String availability = this.device.isDeviceAvailable() ? "available" : "not available";
        return String.format("%s %s (%s)", new Object[]{this.device.getDeviceName(), this.device.getDeviceType(), availability});
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public OCLTargetDevice getPhysicalDevice() {
        return this.device;
    }

    public TornadoMemoryProvider getMemoryProvider() {
        TornadoInternalError.unimplemented();
        return this.getDeviceContext().getMemoryManager();
    }

    public OCLDeviceContextInterface getDeviceContext() {
        return this.getBackend().getDeviceContext();
    }

    public OCLBackend getBackend() {
        return VirtualOCLTornadoDevice.findDriver().getBackend(this.platformIndex, this.deviceIndex);
    }

    public void clean() {
        HashSet ids = new HashSet(this.device.getDeviceContext().getRegisteredPlanIds());
        if (!ids.isEmpty()) {
            ids.forEach(id -> this.device.getDeviceContext().reset((long)id));
            ids.clear();
        }
    }

    public String toString() {
        return this.getPlatformName() + " -- " + this.device.getDeviceName();
    }

    public TornadoSchedulingStrategy getPreferredSchedule() {
        switch (Objects.requireNonNull(this.device.getDeviceType())) {
            case CL_DEVICE_TYPE_GPU: 
            case CL_DEVICE_TYPE_ACCELERATOR: 
            case CL_DEVICE_TYPE_CUSTOM: 
            case CL_DEVICE_TYPE_ALL: {
                return TornadoSchedulingStrategy.PER_ACCELERATOR_ITERATION;
            }
            case CL_DEVICE_TYPE_CPU: {
                if (TornadoOptions.USE_BLOCK_SCHEDULER) {
                    return TornadoSchedulingStrategy.PER_CPU_BLOCK;
                }
                return TornadoSchedulingStrategy.PER_ACCELERATOR_ITERATION;
            }
        }
        TornadoInternalError.shouldNotReachHere();
        return TornadoSchedulingStrategy.PER_ACCELERATOR_ITERATION;
    }

    public void ensureLoaded(long executionPlanId) {
        OCLBackend backend = this.getBackend();
        if (!backend.isInitialised()) {
            backend.init();
        }
    }

    public KernelStackFrame createKernelStackFrame(long executionPlanId, int numArgs, Access access) {
        return null;
    }

    public XPUBuffer createOrReuseAtomicsBuffer(int[] arr, Access access) {
        return null;
    }

    private TornadoInstalledCode compileTask(SchedulableTask task) {
        CompilableTask executable = (CompilableTask)task;
        ResolvedJavaMethod resolvedMethod = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(executable.getMethod());
        Sketch sketch = TornadoSketcher.lookup((ResolvedJavaMethod)resolvedMethod, (int)task.meta().getBackendIndex(), (int)task.meta().getDeviceIndex());
        TaskDataContext taskMeta = executable.meta();
        Access[] sketchAccess = sketch.getArgumentsAccess();
        Access[] taskAccess = taskMeta.getArgumentsAccess();
        System.arraycopy(sketchAccess, 0, taskAccess, 0, sketchAccess.length);
        try {
            OCLProviders providers = (OCLProviders)this.getBackend().getProviders();
            TornadoProfiler profiler = task.getProfiler();
            profiler.start(ProfilerType.TASK_COMPILE_GRAAL_TIME, taskMeta.getId());
            OCLCompilationResult result = OCLCompiler.compileSketchForDevice(sketch, executable, providers, this.getBackend(), executable.getProfiler());
            profiler.stop(ProfilerType.TASK_COMPILE_GRAAL_TIME, taskMeta.getId());
            profiler.sum(ProfilerType.TOTAL_GRAAL_COMPILE_TIME, profiler.getTaskTimer(ProfilerType.TASK_COMPILE_GRAAL_TIME, taskMeta.getId()));
            if (taskMeta.isPrintKernelEnabled()) {
                RuntimeUtilities.dumpKernel((byte[])result.getTargetCode());
            }
            return null;
        }
        catch (Exception e) {
            TornadoLogger tornadoLogger = new TornadoLogger();
            tornadoLogger.fatal("unable to compile %s for device %s", new Object[]{task.getId(), this.getDeviceName()});
            tornadoLogger.fatal("exception occurred when compiling %s", new Object[]{((CompilableTask)task).getMethod().getName()});
            tornadoLogger.fatal("exception: %s", new Object[]{e.toString()});
            throw new TornadoBailoutRuntimeException("[Error During the Task Compilation] ", e);
        }
    }

    private TornadoInstalledCode compilePreBuiltTask(SchedulableTask task) {
        PrebuiltTask executable = (PrebuiltTask)task;
        Path path = Paths.get(executable.getFilename(), new String[0]);
        TornadoInternalError.guarantee((boolean)path.toFile().exists(), (String)"file does not exist: %s", (Object[])new Object[]{executable.getFilename()});
        try {
            byte[] source = Files.readAllBytes(path);
            if (task.meta().isPrintKernelEnabled()) {
                RuntimeUtilities.dumpKernel((byte[])source);
            }
        }
        catch (IOException e) {
            throw new TornadoBailoutRuntimeException(e.getMessage());
        }
        return null;
    }

    private TornadoInstalledCode compileJavaToAccelerator(SchedulableTask task) {
        if (task instanceof CompilableTask) {
            return this.compileTask(task);
        }
        if (task instanceof PrebuiltTask) {
            return this.compilePreBuiltTask(task);
        }
        TornadoInternalError.shouldNotReachHere((String)("task of unknown type: " + task.getClass().getSimpleName()));
        return null;
    }

    public boolean isFullJITMode(long executionPlanId, SchedulableTask task) {
        return true;
    }

    public TornadoInstalledCode getCodeFromCache(long executionPlanId, SchedulableTask task) {
        return null;
    }

    public int[] checkAtomicsForTask(SchedulableTask task) {
        return null;
    }

    public int[] checkAtomicsForTask(SchedulableTask task, int[] array, int paramIndex, Object value) {
        return null;
    }

    public int[] updateAtomicRegionAndObjectState(SchedulableTask task, int[] array, int paramIndex, Object value, XPUDeviceBufferState objectState) {
        return null;
    }

    public int getAtomicsGlobalIndexForTask(SchedulableTask task, int paramIndex) {
        return -1;
    }

    public boolean checkAtomicsParametersForTask(SchedulableTask task) {
        return false;
    }

    public TornadoInstalledCode installCode(long executionPlanId, SchedulableTask task) {
        return this.compileJavaToAccelerator(task);
    }

    public long allocate(Object object, long batchSize, DeviceBufferState state, Access access) {
        TornadoInternalError.unimplemented();
        return -1L;
    }

    public synchronized long allocateObjects(Object[] objects, long batchSize, DeviceBufferState[] states, Access[] accesses) {
        TornadoInternalError.unimplemented();
        return -1L;
    }

    public synchronized long deallocate(DeviceBufferState state) {
        TornadoInternalError.unimplemented();
        return -1L;
    }

    public List<Integer> ensurePresent(long executionPlanId, Object object, DeviceBufferState state, int[] events, long batchSize, long offset) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public List<Integer> streamIn(long executionPlanId, Object object, long batchSize, long offset, DeviceBufferState state, int[] events) {
        TornadoInternalError.unimplemented();
        return null;
    }

    public int streamOut(long executionPlanId, Object object, long offset, DeviceBufferState state, int[] events) {
        TornadoInternalError.unimplemented();
        return -1;
    }

    public int streamOutBlocking(long executionPlanId, Object object, long hostOffset, DeviceBufferState state, int[] events) {
        TornadoInternalError.unimplemented();
        return -1;
    }

    public void flush(long executionPlanId) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualOCLTornadoDevice) {
            VirtualOCLTornadoDevice other = (VirtualOCLTornadoDevice)obj;
            return other.deviceIndex == this.deviceIndex && other.platformIndex == this.platformIndex;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.deviceIndex;
        hash = 89 * hash + this.platformIndex;
        return hash;
    }

    public void sync(long executionPlanId) {
    }

    public int enqueueBarrier(long executionPlanId) {
        TornadoInternalError.unimplemented();
        return this.getDeviceContext().enqueueBarrier(executionPlanId);
    }

    public int enqueueBarrier(long executionPlanId, int[] events) {
        TornadoInternalError.unimplemented();
        return this.getDeviceContext().enqueueBarrier(executionPlanId, events);
    }

    public int enqueueMarker(long executionPlanId) {
        return this.getDeviceContext().enqueueMarker(executionPlanId);
    }

    public int enqueueMarker(long executionPlanId, int[] events) {
        return this.getDeviceContext().enqueueMarker(executionPlanId, events);
    }

    public Event resolveEvent(long executionPlanId, int event) {
        return this.getDeviceContext().resolveEvent(executionPlanId, event);
    }

    public void flushEvents(long executionPlanId) {
        this.getDeviceContext().flushEvents(executionPlanId);
    }

    public String getDeviceName() {
        return String.format("virtualOpencl-%d-%d", this.platformIndex, this.deviceIndex);
    }

    public TornadoDeviceType getDeviceType() {
        OCLDeviceType deviceType = this.device.getDeviceType();
        switch (deviceType) {
            case CL_DEVICE_TYPE_CPU: {
                return TornadoDeviceType.CPU;
            }
            case CL_DEVICE_TYPE_GPU: {
                return TornadoDeviceType.GPU;
            }
            case CL_DEVICE_TYPE_ACCELERATOR: {
                return TornadoDeviceType.ACCELERATOR;
            }
            case CL_DEVICE_TYPE_CUSTOM: {
                return TornadoDeviceType.CUSTOM;
            }
            case CL_DEVICE_TYPE_ALL: {
                return TornadoDeviceType.ALL;
            }
            case CL_DEVICE_TYPE_DEFAULT: {
                return TornadoDeviceType.DEFAULT;
            }
        }
        throw new RuntimeException("Device not supported");
    }

    public long getMaxAllocMemory() {
        return this.device.getDeviceMaxAllocationSize();
    }

    public long getMaxGlobalMemory() {
        return this.device.getDeviceGlobalMemorySize();
    }

    public long getDeviceLocalMemorySize() {
        return this.device.getDeviceLocalMemorySize();
    }

    public long[] getDeviceMaxWorkgroupDimensions() {
        return this.device.getDeviceMaxWorkItemSizes();
    }

    public String getDeviceOpenCLCVersion() {
        return this.device.getDeviceOpenCLCVersion();
    }

    public Object getDeviceInfo() {
        return this.device.getDeviceInfo();
    }

    public int getBackendIndex() {
        return TornadoCoreRuntime.getTornadoRuntime().getBackendIndex(OCLBackendImpl.class);
    }

    public void enableThreadSharing() {
    }

    public void setAtomicRegion(XPUBuffer bufferAtomics) {
    }

    public int getAvailableProcessors() {
        return ((VirtualOCLDevice)this.device).getAvailableProcessors();
    }

    public Object getAtomic() {
        return null;
    }

    public void setAtomicsMapping(ConcurrentHashMap<Object, Integer> mappingAtomics) {
    }

    public TornadoVMBackendType getTornadoVMBackend() {
        return TornadoVMBackendType.VIRTUAL;
    }

    public boolean isSPIRVSupported() {
        return false;
    }

    public void mapDeviceRegion(long executionPlanId, Object destArray, Object srcArray, DeviceBufferState deviceStateSrc, DeviceBufferState deviceStateDest, long offset) {
        throw new UnsupportedOperationException();
    }
}

