/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.virtual;

import java.util.Set;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.drivers.common.TornadoBufferProvider;
import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OCLCodeCache;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLProgram;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLMemoryManager;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualOCLContext;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualOCLTornadoDevice;
import uk.ac.manchester.tornado.runtime.EmptyEvent;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class VirtualOCLDeviceContext
implements OCLDeviceContextInterface {
    private final OCLTargetDevice device;
    private final VirtualOCLContext context;
    private final OCLCodeCache codeCache;
    private boolean wasReset;

    protected VirtualOCLDeviceContext(OCLTargetDevice device, VirtualOCLContext context) {
        this.device = device;
        this.context = context;
        this.codeCache = new OCLCodeCache(this);
        device.setDeviceContext(this);
    }

    @Override
    public OCLTargetDevice getDevice() {
        return this.device;
    }

    public String getDeviceName() {
        return String.format(this.device.getDeviceName(), new Object[0]);
    }

    public int getDriverIndex() {
        return TornadoRuntimeProvider.getTornadoRuntime().getBackendIndex(OCLBackendImpl.class);
    }

    public Set<Long> getRegisteredPlanIds() {
        return Set.of();
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public VirtualOCLContext getPlatformContext() {
        return this.context;
    }

    @Override
    public long getDeviceId() {
        return 0L;
    }

    @Override
    public OCLProgram createProgramWithSource(byte[] source, long[] lengths) {
        return null;
    }

    @Override
    public OCLProgram createProgramWithBinary(byte[] binary, long[] lengths) {
        return null;
    }

    @Override
    public OCLProgram createProgramWithIL(byte[] binary, long[] lengths) {
        return null;
    }

    @Override
    public OCLMemoryManager getMemoryManager() {
        return null;
    }

    @Override
    public TornadoBufferProvider getBufferProvider() {
        return null;
    }

    @Override
    public void sync(long executionPlanId) {
    }

    @Override
    public int enqueueBarrier(long executionPlanId) {
        return 0;
    }

    @Override
    public int enqueueBarrier(long executionPlanId, int[] events) {
        return 0;
    }

    @Override
    public int enqueueMarker(long executionPlanId) {
        return 0;
    }

    @Override
    public int enqueueMarker(long executionPlanId, int[] events) {
        return 0;
    }

    @Override
    public Event resolveEvent(long executionPlanId, int event) {
        return new EmptyEvent();
    }

    @Override
    public void flushEvents(long executionPlanId) {
    }

    @Override
    public void reset(long executionPlanId) {
        this.wasReset = true;
    }

    @Override
    public VirtualOCLTornadoDevice toDevice() {
        return new VirtualOCLTornadoDevice(this.context.getPlatformIndex(), this.device.getIndex());
    }

    public String getId() {
        return String.format("opencl-%d-%d", this.context.getPlatformIndex(), this.device.getIndex());
    }

    @Override
    public void dumpEvents() {
    }

    @Override
    public void flush(long executionPlanId) {
    }

    public boolean wasReset() {
        return this.wasReset;
    }

    public void setResetToFalse() {
        this.wasReset = false;
    }

    public boolean isPlatformFPGA() {
        return this.getDevice().getDeviceType() == OCLDeviceType.CL_DEVICE_TYPE_ACCELERATOR && (this.getPlatformContext().getPlatform().getName().toLowerCase().contains("fpga") || this.isPlatformXilinxFPGA());
    }

    public boolean isPlatformXilinxFPGA() {
        return this.getPlatformContext().getPlatform().getName().toLowerCase().contains("xilinx");
    }

    public boolean isFP64Supported() {
        return this.device.isDeviceDoubleFPSupported();
    }

    public int getDeviceIndex() {
        return this.device.getIndex();
    }

    public int getDevicePlatform() {
        return this.context.getPlatformIndex();
    }

    @Override
    public boolean isKernelAvailable(long executionPlanId) {
        return true;
    }

    @Override
    public OCLInstalledCode installCode(long executionPlanId, OCLCompilationResult result) {
        return null;
    }

    @Override
    public OCLInstalledCode installCode(long executionPlanId, TaskDataContext meta, String id, String entryPoint, byte[] code) {
        return null;
    }

    @Override
    public OCLInstalledCode installCode(long executionPlanId, String id, String entryPoint, byte[] code, boolean printKernel) {
        return null;
    }

    @Override
    public boolean isCached(long executionPlanId, String id, String entryPoint) {
        return false;
    }

    @Override
    public OCLInstalledCode getInstalledCode(long executionPlanId, String id, String entryPoint) {
        return null;
    }

    @Override
    public OCLCodeCache getCodeCache(long executionPlanId) {
        return this.codeCache;
    }

    public boolean isCached(long executionPlanId, String methodName, SchedulableTask task) {
        return false;
    }
}

