/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.virtual;

import java.nio.ByteOrder;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualDeviceDescriptor;

public class VirtualOCLDevice
implements OCLTargetDevice {
    private final int index;
    private final String name;
    private final boolean deviceEndianLittle;
    private final int maxComputeUnits;
    private final long maxAllocationSize;
    private final long globalMemorySize;
    private final long localMemorySize;
    private final int maxWorkItemDimensions;
    private final long[] maxWorkItemSizes;
    private final long[] maxWorkGroupSize;
    private final long maxConstantBufferSize;
    private final boolean doubleFPConfig;
    private final long singleFPConfig;
    private final OCLDeviceType deviceType;
    private final int deviceMaxClockFrequency;
    private final int deviceAddressBits;
    private final String deviceExtensions;
    private final int availableProcessors;
    private static final int INIT_VALUE = -1;
    private OCLDeviceContextInterface deviceContex;

    public VirtualOCLDevice(VirtualDeviceDescriptor info) {
        this.name = info.getDeviceName();
        this.index = 0;
        this.deviceEndianLittle = true;
        this.maxComputeUnits = -1;
        this.maxAllocationSize = -1L;
        this.globalMemorySize = -1L;
        this.localMemorySize = -1L;
        this.maxWorkItemDimensions = -1;
        this.maxWorkGroupSize = null;
        this.maxConstantBufferSize = -1L;
        this.deviceMaxClockFrequency = -1;
        this.deviceAddressBits = info.getDeviceAddressBits();
        this.doubleFPConfig = info.getDoubleFPSupport();
        this.singleFPConfig = -1L;
        this.maxWorkItemSizes = info.getMaxWorkItemSizes();
        this.deviceType = info.deviceType();
        this.deviceExtensions = info.getDeviceExtensions();
        this.availableProcessors = info.getAvailableProcessors();
    }

    @Override
    public long getDevicePointer() {
        return -1L;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public OCLDeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public boolean isDeviceAvailable() {
        return true;
    }

    public String getDeviceName() {
        return this.name;
    }

    @Override
    public String getDeviceVendor() {
        return "DummyVendor";
    }

    @Override
    public String getDriverVersion() {
        return "DummyDriverVersion";
    }

    public String getDeviceVersion() {
        return "DummyDeviceVersion";
    }

    @Override
    public String getDeviceOpenCLCVersion() {
        return "DummyOpenCLCVersion";
    }

    @Override
    public String getDeviceExtensions() {
        return this.deviceExtensions;
    }

    public int getDeviceMaxComputeUnits() {
        return this.maxComputeUnits;
    }

    public int getDeviceMaxClockFrequency() {
        return this.deviceMaxClockFrequency;
    }

    public long getDeviceMaxAllocationSize() {
        return this.maxAllocationSize;
    }

    public long getDeviceGlobalMemorySize() {
        return this.globalMemorySize;
    }

    public long getDeviceLocalMemorySize() {
        return this.localMemorySize;
    }

    public int getDeviceMaxWorkItemDimensions() {
        return this.maxWorkItemDimensions;
    }

    public long[] getDeviceMaxWorkItemSizes() {
        return this.maxWorkItemSizes;
    }

    public long[] getDeviceMaxWorkGroupSize() {
        return this.maxWorkGroupSize;
    }

    public int getMaxThreadsPerBlock() {
        return (int)this.maxWorkGroupSize[0];
    }

    public long getDeviceMaxConstantBufferSize() {
        return this.maxConstantBufferSize;
    }

    @Override
    public boolean isDeviceDoubleFPSupported() {
        return this.doubleFPConfig;
    }

    public long getDeviceSingleFPConfig() {
        return this.singleFPConfig;
    }

    public int getDeviceAddressBits() {
        return this.deviceAddressBits;
    }

    public boolean hasDeviceUnifiedMemory() {
        return false;
    }

    @Override
    public boolean isLittleEndian() {
        return this.deviceEndianLittle;
    }

    @Override
    public OCLDeviceContextInterface getDeviceContext() {
        return this.deviceContex;
    }

    @Override
    public void setDeviceContext(OCLDeviceContextInterface deviceContext) {
        this.deviceContex = deviceContext;
    }

    @Override
    public int deviceVersion() {
        return 0;
    }

    @Override
    public boolean isSPIRVSupported() {
        return true;
    }

    @Override
    public int getWordSize() {
        return this.getDeviceAddressBits() >> 3;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("id=0x%x, deviceName=%s, type=%s, available=%s", -1, this.getDeviceName(), this.getDeviceType().toString(), this.isDeviceAvailable()));
        return sb.toString();
    }

    public String getDeviceInfo() {
        return "DummyDeviceInfo";
    }

    @Override
    public String getVersion() {
        TornadoInternalError.unimplemented();
        return null;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }
}

