/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.virtual;

import java.util.ArrayList;
import java.util.List;
import uk.ac.manchester.tornado.drivers.opencl.OCLContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualOCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualOCLPlatform;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public class VirtualOCLContext
implements OCLContextInterface {
    private final List<OCLTargetDevice> devices;
    private final VirtualOCLPlatform platform;

    public VirtualOCLContext(VirtualOCLPlatform platform, OCLTargetDevice device) {
        this.platform = platform;
        this.devices = new ArrayList<OCLTargetDevice>();
        this.devices.add(device);
    }

    @Override
    public int getNumDevices() {
        return 1;
    }

    @Override
    public List<OCLTargetDevice> devices() {
        return this.devices;
    }

    @Override
    public long getContextId() {
        return 0L;
    }

    public void cleanup() {
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public VirtualOCLDeviceContext createDeviceContext(int index) {
        new TornadoLogger().debug("creating device context for device: %s", new Object[]{this.devices.get(index).toString()});
        return new VirtualOCLDeviceContext(this.devices.get(index), this);
    }

    @Override
    public int getPlatformIndex() {
        return this.platform.getIndex();
    }

    @Override
    public VirtualOCLPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public void createCommandQueue(int index) {
    }
}

