/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.virtual;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.virtual.VirtualDeviceDescriptor;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class VirtualJSONParser {
    private static final Pattern pattern = Pattern.compile(" |\",|\"|\t|]|\\[");

    public static VirtualDeviceDescriptor getDeviceDescriptor() {
        String json = VirtualJSONParser.readVirtualDeviceJson();
        HashMap<JsonKey, String> jsonEntries = new HashMap<JsonKey, String>();
        for (String line : json.split("\n")) {
            String value;
            Matcher matcher = pattern.matcher(line);
            String[] keyValue = matcher.replaceAll("").split(":");
            String key = keyValue[0];
            String string = value = keyValue.length > 1 ? keyValue[1] : null;
            if (value == null) continue;
            value = value.charAt(value.length() - 1) == ',' ? value.substring(0, value.length() - 1) : value;
            jsonEntries.put(JsonKey.valueOf(key), value);
        }
        String deviceName = (String)VirtualJSONParser.getEntryForKey(JsonKey.deviceName, jsonEntries);
        boolean doubleFPSupport = (Boolean)VirtualJSONParser.getEntryForKey(JsonKey.doubleFPSupport, jsonEntries);
        long[] maxWorkItemSizes = (long[])VirtualJSONParser.getEntryForKey(JsonKey.maxWorkItemSizes, jsonEntries);
        int deviceAddressBits = (Integer)VirtualJSONParser.getEntryForKey(JsonKey.deviceAddressBits, jsonEntries);
        OCLDeviceType deviceType = (OCLDeviceType)((Object)VirtualJSONParser.getEntryForKey(JsonKey.deviceType, jsonEntries));
        String deviceExtensions = (String)VirtualJSONParser.getEntryForKey(JsonKey.deviceExtensions, jsonEntries);
        int availableProcessors = (Integer)VirtualJSONParser.getEntryForKey(JsonKey.availableProcessors, jsonEntries);
        return new VirtualDeviceDescriptor(deviceName, doubleFPSupport, maxWorkItemSizes, deviceAddressBits, deviceType, deviceExtensions, availableProcessors);
    }

    private static Object getEntryForKey(JsonKey jsonKey, Map<JsonKey, String> jsonEntries) {
        switch (jsonKey.ordinal()) {
            case 0: 
            case 5: {
                return jsonEntries.get((Object)jsonKey);
            }
            case 1: {
                return Boolean.parseBoolean(jsonEntries.get((Object)jsonKey));
            }
            case 2: {
                long[] values = new long[3];
                String[] numbers = jsonEntries.get((Object)jsonKey).split(",");
                values[0] = Long.parseLong(numbers[0]);
                values[1] = Long.parseLong(numbers[1]);
                values[2] = Long.parseLong(numbers[2]);
                return values;
            }
            case 3: 
            case 6: {
                return Integer.parseInt(jsonEntries.get((Object)jsonKey));
            }
            case 4: {
                return OCLDeviceType.valueOf(jsonEntries.get((Object)jsonKey));
            }
        }
        throw new RuntimeException("Virtual device JSON parser failed ! Unknown json key: " + jsonKey.name());
    }

    private static String readVirtualDeviceJson() {
        Path path = Paths.get(TornadoOptions.VIRTUAL_DEVICE_FILE, new String[0]);
        TornadoInternalError.guarantee((boolean)path.toFile().exists(), (String)"Virtual device file does not exist: %s", (Object[])new Object[]{TornadoOptions.VIRTUAL_DEVICE_FILE});
        try {
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to read from %s", TornadoOptions.VIRTUAL_DEVICE_FILE), e);
        }
    }

    private static enum JsonKey {
        deviceName,
        doubleFPSupport,
        maxWorkItemSizes,
        deviceAddressBits,
        deviceType,
        deviceExtensions,
        availableProcessors;

    }
}

