/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.tests;

import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OCLCodeCache;
import uk.ac.manchester.tornado.drivers.opencl.OCLContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLPlatform;
import uk.ac.manchester.tornado.drivers.opencl.OpenCL;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class TestOpenCLTornadoCompiler {
    private static final String OPENCL_KERNEL = "__kernel void saxpy(__global float *a,    __global float *b, __global float *c) {       int idx = get_global_id(0);       c[idx]  =  a[idx] + b[idx]; }";

    public static void main(String[] args) {
        OCLPlatform platform = (OCLPlatform)OpenCL.getPlatform(0);
        OCLContext oclContext = platform.createContext();
        oclContext.createCommandQueue(0);
        OCLDeviceContext deviceContext = oclContext.createDeviceContext(0);
        OCLCodeCache codeCache = new OCLCodeCache(deviceContext);
        TornadoCoreRuntime tornadoRuntime = TornadoCoreRuntime.getTornadoRuntime();
        OCLBackend backend = ((OCLBackendImpl)tornadoRuntime.getBackend(OCLBackendImpl.class)).getDefaultBackend();
        ScheduleContext scheduleMeta = new ScheduleContext("oclbackend");
        TaskDataContext meta = new TaskDataContext(scheduleMeta, "saxpy");
        new OCLCompilationResult("internal", "saxpy", meta, backend);
        byte[] source = OPENCL_KERNEL.getBytes();
        OCLInstalledCode code = codeCache.installSource(meta, "saxpy", "saxpy", source);
        String generatedSourceCode = code.getGeneratedSourceCode();
        if (meta.isPrintKernelEnabled()) {
            System.out.println("Compiled code: " + generatedSourceCode);
        }
    }
}

