/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.tests;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.phases.util.Providers;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.drivers.common.MetaCompilation;
import uk.ac.manchester.tornado.drivers.common.utils.CompilerUtil;
import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OpenCL;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLProviders;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLSuitesProvider;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompiler;
import uk.ac.manchester.tornado.drivers.opencl.runtime.OCLTornadoDevice;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.KernelStackFrame;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;
import uk.ac.manchester.tornado.runtime.graal.compiler.TornadoSuitesProvider;
import uk.ac.manchester.tornado.runtime.profiler.EmptyProfiler;
import uk.ac.manchester.tornado.runtime.sketcher.Sketch;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;
import uk.ac.manchester.tornado.runtime.tasks.DataObjectState;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class TestOpenCLJITCompiler {
    public static void methodToCompile(int[] a, int[] b, float[] c) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 0.12f * (float)a[i] * (float)b[i];
        }
    }

    public static void main(String[] args) {
        System.out.print("Running Native: uk.ac.manchester.tornado.drivers.opencl.tests.TestOpenCLJITCompiler");
        new TestOpenCLJITCompiler().test();
    }

    public MetaCompilation compileMethod(long executionPlanId, Class<?> klass, String methodName, OCLTornadoDevice tornadoDevice, Object ... parameters) {
        Method methodToCompile = CompilerUtil.getMethodForName(klass, (String)methodName);
        TornadoCoreRuntime tornadoRuntime = TornadoCoreRuntime.getTornadoRuntime();
        ResolvedJavaMethod resolvedJavaMethod = tornadoRuntime.resolveMethod(methodToCompile);
        OCLBackend openCLBackend = ((OCLBackendImpl)tornadoRuntime.getBackend(OCLBackendImpl.class)).getDefaultBackend();
        TornadoXPUDevice device = ((OCLBackendImpl)tornadoRuntime.getBackend(OCLBackendImpl.class)).getDefaultDevice();
        ScheduleContext scheduleMetaData = new ScheduleContext("s0");
        CompilableTask compilableTask = new CompilableTask(scheduleMetaData, "t0", methodToCompile, parameters);
        TaskDataContext taskMeta = compilableTask.meta();
        taskMeta.setDevice((TornadoDevice)device);
        Providers providers = openCLBackend.getProviders();
        OCLSuitesProvider suites = openCLBackend.getTornadoSuites();
        Sketch sketch = CompilerUtil.buildSketchForJavaMethod((ResolvedJavaMethod)resolvedJavaMethod, (TaskDataContext)taskMeta, (Providers)providers, (TornadoSuitesProvider)suites);
        OCLCompilationResult compilationResult = OCLCompiler.compileSketchForDevice(sketch, compilableTask, (OCLProviders)providers, openCLBackend, (TornadoProfiler)new EmptyProfiler());
        OCLInstalledCode openCLCode = tornadoDevice.getDeviceContext().installCode(executionPlanId, compilationResult);
        return new MetaCompilation(taskMeta, (InstalledCode)openCLCode);
    }

    public void runWithOpenCLAPI(Long executionPlanId, OCLTornadoDevice tornadoDevice, OCLInstalledCode openCLCode, TaskDataContext taskMeta, int[] a, int[] b, float[] c) {
        OpenCL.run(executionPlanId, tornadoDevice, openCLCode, taskMeta, new Access[]{Access.READ_ONLY, Access.READ_ONLY, Access.WRITE_ONLY}, a, b, c);
    }

    public void run(OCLTornadoDevice tornadoDevice, OCLInstalledCode openCLCode, TaskDataContext taskMeta, int[] a, int[] b, float[] c) {
        DataObjectState stateA = new DataObjectState();
        XPUDeviceBufferState objectStateA = stateA.getDeviceBufferState((TornadoDevice)tornadoDevice);
        DataObjectState stateB = new DataObjectState();
        XPUDeviceBufferState objectStateB = stateB.getDeviceBufferState((TornadoDevice)tornadoDevice);
        DataObjectState stateC = new DataObjectState();
        XPUDeviceBufferState objectStateC = stateC.getDeviceBufferState((TornadoDevice)tornadoDevice);
        tornadoDevice.allocateObjects(new Object[]{a, b, c}, 0L, new DeviceBufferState[]{objectStateA, objectStateB, objectStateC}, new Access[]{Access.READ_ONLY, Access.READ_ONLY, Access.WRITE_ONLY});
        long executionPlanId = 0L;
        tornadoDevice.ensurePresent(executionPlanId, a, (DeviceBufferState)objectStateA, null, 0L, 0L);
        tornadoDevice.ensurePresent(executionPlanId, b, (DeviceBufferState)objectStateB, null, 0L, 0L);
        KernelStackFrame callWrapper = tornadoDevice.createKernelStackFrame(executionPlanId, 3, Access.NONE);
        callWrapper.setKernelContext(new HashMap());
        callWrapper.addCallArgument((Object)objectStateA.getXPUBuffer().toBuffer(), true);
        callWrapper.addCallArgument((Object)objectStateB.getXPUBuffer().toBuffer(), true);
        callWrapper.addCallArgument((Object)objectStateC.getXPUBuffer().toBuffer(), true);
        openCLCode.launchWithoutDependencies(executionPlanId, callWrapper, null, taskMeta, 0L);
        tornadoDevice.streamOutBlocking(executionPlanId, c, 0L, (DeviceBufferState)objectStateC, null);
    }

    public void test() {
        int N = 128;
        int[] a = new int[128];
        int[] b = new int[128];
        float[] c = new float[128];
        Arrays.fill(a, -10);
        Arrays.fill(b, 10);
        long executionPlanId = 0L;
        OCLTornadoDevice tornadoDevice = (OCLTornadoDevice)((OCLBackendImpl)TornadoCoreRuntime.getTornadoRuntime().getBackend(OCLBackendImpl.class)).getDefaultDevice();
        MetaCompilation compileMethod = this.compileMethod(executionPlanId, TestOpenCLJITCompiler.class, "methodToCompile", tornadoDevice, a, b, c);
        this.run(tornadoDevice, (OCLInstalledCode)compileMethod.getInstalledCode(), compileMethod.getTaskMeta(), a, b, c);
        this.runWithOpenCLAPI(executionPlanId, tornadoDevice, (OCLInstalledCode)compileMethod.getInstalledCode(), compileMethod.getTaskMeta(), a, b, c);
        boolean correct = true;
        for (int i = 0; i < c.length; ++i) {
            float seq = 0.12f * (float)a[i] * (float)b[i];
            if (!((double)Math.abs(c[i] - seq) > 0.01)) continue;
            correct = false;
            break;
        }
        if (!correct) {
            System.out.println(" ................ [FAIL]");
        } else {
            System.out.println(" ................ [PASS]");
        }
    }
}

