/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.scheduler;

import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLAMDScheduler;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLCPUScheduler;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLFPGAScheduler;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLGenericGPUScheduler;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLKernelScheduler;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLNVIDIAGPUScheduler;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class OCLScheduler {
    private static final int NVIDIA_MAJOR_VERSION_GENERIC_SCHEDULER = 550;
    private static final int NVIDIA_MINOR_VERSION_GENERIC_SCHEDULER = 67;

    private static boolean isDriverVersionCompatible(OCLTargetDevice device) {
        int majorVersion = Integer.parseInt(device.getDriverVersion().split("\\.")[0]);
        int minorVersion = Integer.parseInt(device.getDriverVersion().split("\\.")[1]);
        if (majorVersion == 550 && minorVersion >= 67) {
            return true;
        }
        return majorVersion > 550;
    }

    private static OCLKernelScheduler getInstanceGPUScheduler(OCLDeviceContext context) {
        OCLTargetDevice device = context.getDevice();
        if (device.getDeviceVendor().contains(SUPPORTED_VENDORS.AMD.getName())) {
            return new OCLAMDScheduler(context);
        }
        if (device.getDeviceVendor().contains(SUPPORTED_VENDORS.NVIDIA.getName())) {
            return OCLScheduler.isDriverVersionCompatible(device) ? new OCLNVIDIAGPUScheduler(context) : new OCLGenericGPUScheduler(context);
        }
        return new OCLGenericGPUScheduler(context);
    }

    public static OCLKernelScheduler instanceScheduler(OCLDeviceType type, OCLDeviceContext context) {
        switch (type) {
            case CL_DEVICE_TYPE_GPU: {
                return OCLScheduler.getInstanceGPUScheduler(context);
            }
            case CL_DEVICE_TYPE_ACCELERATOR: {
                if (context.getDevice().getDeviceVendor().contains(SUPPORTED_VENDORS.CODEPLAY.getName())) {
                    return OCLScheduler.getInstanceGPUScheduler(context);
                }
                if (context.isPlatformFPGA()) {
                    return new OCLFPGAScheduler(context);
                }
                return new OCLCPUScheduler(context);
            }
            case CL_DEVICE_TYPE_CPU: {
                return TornadoOptions.USE_BLOCK_SCHEDULER ? new OCLCPUScheduler(context) : OCLScheduler.getInstanceGPUScheduler(context);
            }
        }
        new TornadoLogger().fatal("No scheduler available for device: %s", new Object[]{context});
        return null;
    }

    public static OCLKernelScheduler create(OCLDeviceContext context) {
        if (context.getDevice().getDeviceType() != null) {
            OCLDeviceType type = context.getDevice().getDeviceType();
            return OCLScheduler.instanceScheduler(type, context);
        }
        return null;
    }

    public static enum SUPPORTED_VENDORS {
        AMD("Advanced Micro Devices"),
        CODEPLAY("Codeplay"),
        INTEL("Intel"),
        NVIDIA("NVIDIA"),
        XILINX("Xilinx");

        private String name;

        private SUPPORTED_VENDORS(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

