/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.scheduler;

import java.util.Arrays;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLGridInfo;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.UpsMeterReader;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public abstract class OCLKernelScheduler {
    protected final OCLDeviceContext deviceContext;
    protected double min;
    protected double max;
    public final String WARNING_FPGA_THREAD_LOCAL = "[TornadoVM OCL] Warning: TornadoVM changed the user-defined local size to: " + (this.getDefaultLocalWorkGroup() != null ? Arrays.toString(this.getDefaultLocalWorkGroup()) : "null") + ".";
    public static final String WARNING_THREAD_LOCAL = "[TornadoVM OCL] Warning: TornadoVM changed the user-defined local size to null. Now, the OpenCL driver will select the best configuration.";

    protected OCLKernelScheduler(OCLDeviceContext context) {
        this.deviceContext = context;
    }

    public abstract void calculateGlobalWork(TaskDataContext var1, long var2);

    public abstract void calculateLocalWork(TaskDataContext var1);

    public abstract void checkAndAdaptLocalWork(TaskDataContext var1);

    public long[] getDefaultLocalWorkGroup() {
        return null;
    }

    public int submit(long executionPlanId, OCLKernel kernel, TaskDataContext meta, long batchThreads) {
        return this.submit(executionPlanId, kernel, meta, null, batchThreads);
    }

    private void updateProfiler(long executionPlanId, int taskEvent, TaskDataContext meta) {
        if (TornadoOptions.isProfilerEnabled()) {
            meta.getProfiler().setTaskPowerUsage(ProfilerType.POWER_USAGE_mW, meta.getId(), this.deviceContext.getPowerUsage());
            if (TornadoOptions.isUpsReaderEnabled()) {
                meta.getProfiler().setSystemPowerConsumption(ProfilerType.SYSTEM_POWER_CONSUMPTION_W, meta.getId(), UpsMeterReader.getOutputPowerMetric() != null ? Long.parseLong(UpsMeterReader.getOutputPowerMetric()) : -1L);
                meta.getProfiler().setSystemVoltage(ProfilerType.SYSTEM_VOLTAGE_V, meta.getId(), UpsMeterReader.getOutputVoltageMetric() != null ? Long.parseLong(UpsMeterReader.getOutputVoltageMetric()) : -1L);
            }
            Event tornadoKernelEvent = this.deviceContext.resolveEvent(executionPlanId, taskEvent);
            tornadoKernelEvent.waitForEvents(executionPlanId);
            long timer = meta.getProfiler().getTimer(ProfilerType.TOTAL_KERNEL_TIME);
            meta.getProfiler().setTimer(ProfilerType.TOTAL_KERNEL_TIME, timer + tornadoKernelEvent.getElapsedTime());
            meta.getProfiler().setTaskTimer(ProfilerType.TASK_KERNEL_TIME, meta.getId(), tornadoKernelEvent.getElapsedTime());
            long dispatchValue = meta.getProfiler().getTimer(ProfilerType.TOTAL_DISPATCH_KERNEL_TIME);
            meta.getProfiler().setTimer(ProfilerType.TOTAL_DISPATCH_KERNEL_TIME, dispatchValue += tornadoKernelEvent.getDriverDispatchTime());
        }
    }

    public int launch(long executionPlanId, OCLKernel kernel, TaskDataContext meta, int[] waitEvents, long batchThreads) {
        if (meta.isWorkerGridAvailable()) {
            WorkerGrid grid = meta.getWorkerGrid(meta.getId());
            long[] global = grid.getGlobalWork();
            long[] offset = grid.getGlobalOffset();
            long[] local = grid.getLocalWork();
            return this.deviceContext.enqueueNDRangeKernel(executionPlanId, kernel, grid.dimension(), offset, global, local, waitEvents);
        }
        return this.deviceContext.enqueueNDRangeKernel(executionPlanId, kernel, meta.getDims(), meta.getGlobalOffset(), meta.getGlobalWork(), meta.shouldUseOpenCLDriverScheduling() ? null : meta.getLocalWork(), waitEvents);
    }

    private void checkLocalWorkGroupFitsOnDevice(TaskDataContext meta) {
        OCLGridInfo gridInfo;
        boolean checkedDimensions;
        WorkerGrid grid = meta.getWorkerGrid(meta.getId());
        long[] local = grid.getLocalWork();
        if (local != null && !(checkedDimensions = (gridInfo = new OCLGridInfo(this.deviceContext, local)).checkGridDimensions())) {
            if (this.deviceContext.isPlatformFPGA()) {
                System.out.println(this.WARNING_FPGA_THREAD_LOCAL);
                grid.setLocalWork(64L, 1L, 1L);
                grid.setNumberOfWorkgroupsToNull();
            } else {
                System.out.println(WARNING_THREAD_LOCAL);
                grid.setLocalWorkToNull();
                grid.setNumberOfWorkgroupsToNull();
            }
        }
    }

    public int submit(long executionPlanId, OCLKernel kernel, TaskDataContext meta, int[] waitEvents, long batchThreads) {
        if (!meta.isWorkerGridAvailable()) {
            if (!meta.isGlobalWorkDefined()) {
                this.calculateGlobalWork(meta, batchThreads);
            }
            if (!meta.isLocalWorkDefined()) {
                this.calculateLocalWork(meta);
                this.checkAndAdaptLocalWork(meta);
            }
        } else {
            this.checkLocalWorkGroupFitsOnDevice(meta);
        }
        if (meta.isThreadInfoEnabled()) {
            meta.printThreadDims();
        }
        int taskEvent = this.launch(executionPlanId, kernel, meta, waitEvents, batchThreads);
        this.updateProfiler(executionPlanId, taskEvent, meta);
        return taskEvent;
    }
}

