/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.scheduler;

import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLKernelScheduler;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLGenericGPUScheduler
extends OCLKernelScheduler {
    private static final int WARP_SIZE = 32;
    private boolean ADJUST_IRREGULAR = false;
    private final long[] maxWorkItemSizes;

    public OCLGenericGPUScheduler(OCLDeviceContext context) {
        super(context);
        OCLTargetDevice device = context.getDevice();
        this.maxWorkItemSizes = device.getDeviceMaxWorkItemSizes();
    }

    @Override
    public void calculateGlobalWork(TaskDataContext meta, long batchThreads) {
        long[] globalWork = meta.getGlobalWork();
        for (int i = 0; i < meta.getDims(); ++i) {
            long value;
            long l = value = batchThreads <= 0L ? (long)meta.getDomain().get(i).cardinality() : batchThreads;
            if (this.ADJUST_IRREGULAR && value % 32L != 0L) {
                value = (value / 32L + 1L) * 32L;
            }
            globalWork[i] = value;
        }
    }

    @Override
    public void calculateLocalWork(TaskDataContext meta) {
        long[] localWork = meta.initLocalWork();
        switch (meta.getDims()) {
            case 3: {
                localWork[2] = 1L;
                localWork[1] = this.calculateGroupSize(this.calculateEffectiveMaxWorkItemSizes(meta)[1], meta.getGlobalWork()[1]);
                localWork[0] = this.calculateGroupSize(this.calculateEffectiveMaxWorkItemSizes(meta)[0], meta.getGlobalWork()[0]);
                break;
            }
            case 2: {
                localWork[1] = this.calculateGroupSize(this.calculateEffectiveMaxWorkItemSizes(meta)[1], meta.getGlobalWork()[1]);
                localWork[0] = this.calculateGroupSize(this.calculateEffectiveMaxWorkItemSizes(meta)[0], meta.getGlobalWork()[0]);
                break;
            }
            case 1: {
                localWork[0] = this.calculateGroupSize(this.calculateEffectiveMaxWorkItemSizes(meta)[0], meta.getGlobalWork()[0]);
                break;
            }
        }
    }

    @Override
    public void checkAndAdaptLocalWork(TaskDataContext meta) {
    }

    private int calculateGroupSize(long maxBlockSize, long globalWorkSize) {
        int value;
        if (maxBlockSize == globalWorkSize) {
            maxBlockSize /= 4L;
        }
        if ((value = (int)Math.min(maxBlockSize, globalWorkSize)) == 0) {
            return 1;
        }
        while (globalWorkSize % (long)value != 0L) {
            --value;
        }
        return value;
    }

    private long[] calculateEffectiveMaxWorkItemSizes(TaskDataContext metaData) {
        long[] intermediates = new long[]{1L, 1L, 1L};
        switch (metaData.getDims()) {
            case 3: {
                intermediates[2] = (long)Math.sqrt(this.maxWorkItemSizes[2]);
                intermediates[1] = (long)Math.sqrt(this.maxWorkItemSizes[1]);
                intermediates[0] = (long)Math.sqrt(this.maxWorkItemSizes[0]);
                break;
            }
            case 2: {
                intermediates[1] = (long)Math.sqrt(this.maxWorkItemSizes[1]);
                intermediates[0] = (long)Math.sqrt(this.maxWorkItemSizes[0]);
                break;
            }
            case 1: {
                intermediates[0] = this.maxWorkItemSizes[0];
                break;
            }
        }
        return intermediates;
    }
}

