/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.scheduler;

import java.util.Arrays;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLKernelScheduler;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLFPGAScheduler
extends OCLKernelScheduler {
    public static final long[] DEFAULT_LOCAL_WORK_SIZE = new long[]{64L, 1L, 1L};
    public static final String WARNING_FPGA_DEFAULT_LOCAL = "[TornadoVM OCL] Warning: TornadoVM uses as default local work group size for FPGAs: " + Arrays.toString(DEFAULT_LOCAL_WORK_SIZE) + ".";
    private static final int WARP = 32;

    public OCLFPGAScheduler(OCLDeviceContext context) {
        super(context);
    }

    @Override
    public void calculateGlobalWork(TaskDataContext meta, long batchThreads) {
        long[] globalWork = meta.getGlobalWork();
        for (int i = 0; i < meta.getDims(); ++i) {
            long value;
            long l = value = batchThreads <= 0L ? (long)meta.getDomain().get(i).cardinality() : batchThreads;
            if (value % 32L != 0L) {
                value = (value / 32L + 1L) * 32L;
            }
            globalWork[i] = value;
        }
    }

    @Override
    public void calculateLocalWork(TaskDataContext meta) {
        long[] localWork = DEFAULT_LOCAL_WORK_SIZE;
        switch (meta.getDims()) {
            case 3: {
                this.setLocalWork(3, localWork, meta);
                break;
            }
            case 2: {
                this.setLocalWork(2, localWork, meta);
                break;
            }
            case 1: {
                this.setLocalWork(1, localWork, meta);
                break;
            }
        }
    }

    @Override
    public void checkAndAdaptLocalWork(TaskDataContext meta) {
    }

    @Override
    public int launch(long executionPlanId, OCLKernel kernel, TaskDataContext meta, int[] waitEvents, long batchThreads) {
        if (meta.isWorkerGridAvailable()) {
            WorkerGrid grid = meta.getWorkerGrid(meta.getId());
            long[] global = grid.getGlobalWork();
            long[] offset = grid.getGlobalOffset();
            long[] local = grid.getLocalWork();
            return this.deviceContext.enqueueNDRangeKernel(executionPlanId, kernel, grid.dimension(), offset, global, local, waitEvents);
        }
        if (meta.shouldUseOpenCLDriverScheduling()) {
            System.out.println(WARNING_FPGA_DEFAULT_LOCAL);
        }
        return this.deviceContext.enqueueNDRangeKernel(executionPlanId, kernel, meta.getDims(), meta.getGlobalOffset(), meta.getGlobalWork(), meta.getLocalWork(), waitEvents);
    }

    @Override
    public long[] getDefaultLocalWorkGroup() {
        return DEFAULT_LOCAL_WORK_SIZE;
    }

    private void setLocalWork(int dimensions, long[] localWork, TaskDataContext meta) {
        for (int i = 0; i < dimensions; ++i) {
            localWork[i] = this.calculateGroupSize(DEFAULT_LOCAL_WORK_SIZE[i], meta.getGlobalWork()[i]);
        }
        meta.setLocalWork(localWork);
    }

    private int calculateGroupSize(long maxWorkItemSizes, long globalWorkSize) {
        int value = (int)Math.min(maxWorkItemSizes, globalWorkSize);
        while (globalWorkSize % (long)value != 0L) {
            --value;
        }
        if ((long)value < maxWorkItemSizes) {
            throw new RuntimeException("[ERROR] Minimum input of 64 elements to run on the FPGA");
        }
        return value;
    }
}

