/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.scheduler;

import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLKernel;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.scheduler.OCLKernelScheduler;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLAMDScheduler
extends OCLKernelScheduler {
    private static final int WARP_SIZE = 64;
    private boolean ADJUST_IRREGULAR = false;
    private final long[] maxWorkItemSizes;

    public OCLAMDScheduler(OCLDeviceContext context) {
        super(context);
        OCLTargetDevice device = context.getDevice();
        this.maxWorkItemSizes = device.getDeviceMaxWorkItemSizes();
    }

    @Override
    public int launch(long executionPlanId, OCLKernel kernel, TaskDataContext meta, int[] waitEvents, long batchThreads) {
        if (meta.isWorkerGridAvailable()) {
            WorkerGrid grid = meta.getWorkerGrid(meta.getId());
            long[] global = grid.getGlobalWork();
            long[] offset = grid.getGlobalOffset();
            long[] local = grid.getLocalWork();
            return this.deviceContext.enqueueNDRangeKernel(executionPlanId, kernel, grid.dimension(), offset, global, local, waitEvents);
        }
        return this.deviceContext.enqueueNDRangeKernel(executionPlanId, kernel, meta.getDims(), meta.getGlobalOffset(), meta.getGlobalWork(), null, waitEvents);
    }

    @Override
    public void calculateGlobalWork(TaskDataContext meta, long batchThreads) {
        long[] globalWork = meta.getGlobalWork();
        for (int i = 0; i < meta.getDims(); ++i) {
            long value;
            long l = value = batchThreads <= 0L ? (long)meta.getDomain().get(i).cardinality() : batchThreads;
            if (this.ADJUST_IRREGULAR && value % 64L != 0L) {
                value = (value / 64L + 1L) * 64L;
            }
            globalWork[i] = value;
        }
    }

    @Override
    public void calculateLocalWork(TaskDataContext meta) {
        long[] localWork = meta.initLocalWork();
        switch (meta.getDims()) {
            case 3: {
                localWork[2] = this.calculateGroupSize(this.maxWorkItemSizes[2], meta.getOpenCLGpuBlock2DY(), meta.getGlobalWork()[2]);
            }
            case 2: {
                localWork[1] = this.calculateGroupSize(this.maxWorkItemSizes[1], meta.getOpenCLGpuBlock2DY(), meta.getGlobalWork()[1]);
                localWork[0] = this.calculateGroupSize(this.maxWorkItemSizes[0], meta.getOpenCLGpuBlock2DX(), meta.getGlobalWork()[0]);
                break;
            }
            case 1: {
                localWork[0] = this.calculateGroupSize(this.maxWorkItemSizes[0], meta.getOpenCLGpuBlockX(), meta.getGlobalWork()[0]);
                break;
            }
        }
    }

    @Override
    public void checkAndAdaptLocalWork(TaskDataContext meta) {
    }

    private int calculateGroupSize(long maxBlockSize, long customBlockSize, long globalWorkSize) {
        int value;
        if (maxBlockSize == globalWorkSize) {
            maxBlockSize /= 4L;
        }
        if ((value = (int)Math.min(Math.max(maxBlockSize, customBlockSize), globalWorkSize)) == 0) {
            return 1;
        }
        while (globalWorkSize % (long)value != 0L) {
            --value;
        }
        return value;
    }
}

