/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.runtime;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.common.SchedulableTask;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.api.memory.TornadoMemoryProvider;
import uk.ac.manchester.tornado.api.memory.XPUBuffer;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.api.runtime.TaskContextInterface;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.Int8Array;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.drivers.common.TornadoBufferProvider;
import uk.ac.manchester.tornado.drivers.opencl.OCLBackendImpl;
import uk.ac.manchester.tornado.drivers.opencl.OCLCodeCache;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContextInterface;
import uk.ac.manchester.tornado.drivers.opencl.OCLTargetDevice;
import uk.ac.manchester.tornado.drivers.opencl.enums.OCLDeviceType;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLInstalledCode;
import uk.ac.manchester.tornado.drivers.opencl.graal.OCLProviders;
import uk.ac.manchester.tornado.drivers.opencl.graal.backend.OCLBackend;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompilationResult;
import uk.ac.manchester.tornado.drivers.opencl.graal.compiler.OCLCompiler;
import uk.ac.manchester.tornado.drivers.opencl.graal.lir.OCLKind;
import uk.ac.manchester.tornado.drivers.opencl.graal.nodes.TornadoAtomicIntegerNode;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLAtomicsBuffer;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLByteArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLCharArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLDoubleArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLFieldBuffer;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLFloatArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLIntArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLLongArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLMemorySegmentWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLMultiDimArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLShortArrayWrapper;
import uk.ac.manchester.tornado.drivers.opencl.mm.OCLVectorWrapper;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.KernelStackFrame;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoInstalledCode;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoSchedulingStrategy;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.common.XPUDeviceBufferState;
import uk.ac.manchester.tornado.runtime.sketcher.Sketch;
import uk.ac.manchester.tornado.runtime.sketcher.TornadoSketcher;
import uk.ac.manchester.tornado.runtime.tasks.CompilableTask;
import uk.ac.manchester.tornado.runtime.tasks.PrebuiltTask;
import uk.ac.manchester.tornado.runtime.tasks.meta.TaskDataContext;

public class OCLTornadoDevice
implements TornadoXPUDevice {
    private static OCLBackendImpl driver = null;
    private static final Pattern NAME_PATTERN = Pattern.compile("^OpenCL (\\d)\\.(\\d).*");
    private final OCLTargetDevice device;
    private final int deviceIndex;
    private final int platformIndex;
    private final String platformName;
    private XPUBuffer atomicsBuffer;
    private ConcurrentHashMap<Object, Integer> mappingAtomics;
    private TornadoLogger logger = new TornadoLogger(this.getClass());

    public OCLTornadoDevice(int platformIndex, int deviceIndex) {
        this.platformIndex = platformIndex;
        this.deviceIndex = deviceIndex;
        driver = (OCLBackendImpl)TornadoCoreRuntime.getTornadoRuntime().getBackend(OCLBackendImpl.class);
        if (driver == null) {
            throw new RuntimeException("TornadoVM OpenCL Driver not found");
        }
        this.platformName = driver.getPlatformContext(platformIndex).getPlatform().getName();
        this.device = driver.getPlatformContext(platformIndex).devices().get(deviceIndex);
        this.mappingAtomics = new ConcurrentHashMap();
    }

    public void dumpEvents(long executionPlanId) {
        this.getDeviceContext().dumpEvents();
    }

    public String getDescription() {
        String availability = this.device.isDeviceAvailable() ? "available" : "not available";
        return String.format("%s %s (%s)", new Object[]{this.device.getDeviceName(), this.device.getDeviceType(), availability});
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public OCLTargetDevice getPhysicalDevice() {
        return this.device;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public TornadoMemoryProvider getMemoryProvider() {
        return this.getDeviceContext().getMemoryManager();
    }

    public int getPlatformIndex() {
        return this.platformIndex;
    }

    public OCLDeviceContextInterface getDeviceContext() {
        return this.getBackend().getDeviceContext();
    }

    public OCLBackend getBackend() {
        return driver.getBackend(this.platformIndex, this.deviceIndex);
    }

    private void disableProfilerOptions() {
        TornadoOptions.TORNADO_PROFILER_LOG = false;
        TornadoOptions.TORNADO_PROFILER = false;
    }

    public void clean() {
        HashSet ids = new HashSet(this.device.getDeviceContext().getRegisteredPlanIds());
        ids.forEach(id -> this.device.getDeviceContext().reset((long)id));
        ids.clear();
        this.disableProfilerOptions();
    }

    public String toString() {
        return String.format(" [" + this.getPlatformName() + "] -- " + this.device.getDeviceName(), new Object[0]);
    }

    public TornadoSchedulingStrategy getPreferredSchedule() {
        switch (Objects.requireNonNull(this.device.getDeviceType())) {
            case CL_DEVICE_TYPE_GPU: 
            case CL_DEVICE_TYPE_ACCELERATOR: 
            case CL_DEVICE_TYPE_CUSTOM: 
            case CL_DEVICE_TYPE_ALL: {
                return TornadoSchedulingStrategy.PER_ACCELERATOR_ITERATION;
            }
            case CL_DEVICE_TYPE_CPU: {
                if (TornadoOptions.USE_BLOCK_SCHEDULER) {
                    return TornadoSchedulingStrategy.PER_CPU_BLOCK;
                }
                return TornadoSchedulingStrategy.PER_ACCELERATOR_ITERATION;
            }
        }
        TornadoInternalError.shouldNotReachHere();
        return TornadoSchedulingStrategy.PER_ACCELERATOR_ITERATION;
    }

    public void ensureLoaded(long executionPlanId) {
        OCLBackend backend = this.getBackend();
        if (!backend.isInitialised()) {
            backend.init();
        }
    }

    public KernelStackFrame createKernelStackFrame(long executionPlanId, int numArgs, Access access) {
        return this.getDeviceContext().getMemoryManager().createKernelStackFrame(executionPlanId, numArgs);
    }

    public XPUBuffer createOrReuseAtomicsBuffer(int[] array, Access access) {
        if (this.atomicsBuffer == null) {
            this.atomicsBuffer = this.getDeviceContext().getMemoryManager().createAtomicsBuffer(array, access);
        }
        this.atomicsBuffer.setIntBuffer(array);
        return this.atomicsBuffer;
    }

    private boolean isOpenCLPreLoadBinary(long executionPlanId, OCLDeviceContextInterface deviceContext, String deviceInfo) {
        OCLCodeCache installedCode = deviceContext.getCodeCache(executionPlanId);
        return installedCode.isLoadBinaryOptionEnabled() && installedCode.getOpenCLBinary(deviceInfo) != null;
    }

    private TornadoInstalledCode compileTask(long executionPlanId, SchedulableTask task) {
        OCLDeviceContextInterface deviceContext = this.getDeviceContext();
        CompilableTask executable = (CompilableTask)task;
        ResolvedJavaMethod resolvedMethod = TornadoCoreRuntime.getTornadoRuntime().resolveMethod(executable.getMethod());
        Sketch sketch = TornadoSketcher.lookup((ResolvedJavaMethod)resolvedMethod, (int)task.meta().getBackendIndex(), (int)task.meta().getDeviceIndex());
        if (!task.shouldCompile() && deviceContext.isCached(executionPlanId, task.getId(), resolvedMethod.getName())) {
            return deviceContext.getInstalledCode(executionPlanId, task.getId(), resolvedMethod.getName());
        }
        TaskDataContext taskMeta = executable.meta();
        Access[] sketchAccess = sketch.getArgumentsAccess();
        Access[] taskAccess = taskMeta.getArgumentsAccess();
        System.arraycopy(sketchAccess, 0, taskAccess, 0, sketchAccess.length);
        try {
            OCLProviders providers = (OCLProviders)this.getBackend().getProviders();
            TornadoProfiler profiler = task.getProfiler();
            profiler.start(ProfilerType.TASK_COMPILE_GRAAL_TIME, taskMeta.getId());
            OCLCompilationResult result = OCLCompiler.compileSketchForDevice(sketch, executable, providers, this.getBackend(), executable.getProfiler());
            ResolvedJavaMethod[] methods = result.getMethods();
            if (methods.length > 1) {
                for (ResolvedJavaMethod m : methods) {
                    if (!TornadoAtomicIntegerNode.globalAtomicsParameters.containsKey(m)) continue;
                    HashMap<Integer, Integer> mapping = TornadoAtomicIntegerNode.globalAtomicsParameters.get(m);
                    for (ResolvedJavaMethod mInternal : methods) {
                        TornadoAtomicIntegerNode.globalAtomicsParameters.put(mInternal, mapping);
                    }
                }
            }
            profiler.stop(ProfilerType.TASK_COMPILE_GRAAL_TIME, taskMeta.getId());
            profiler.sum(ProfilerType.TOTAL_GRAAL_COMPILE_TIME, profiler.getTaskTimer(ProfilerType.TASK_COMPILE_GRAAL_TIME, taskMeta.getId()));
            profiler.start(ProfilerType.TASK_COMPILE_DRIVER_TIME, taskMeta.getId());
            OCLInstalledCode installedCode = OCLBackend.isDeviceAnFPGAAccelerator(deviceContext) ? deviceContext.installCode(executionPlanId, result.getId(), result.getName(), result.getTargetCode(), task.meta().isPrintKernelEnabled()) : deviceContext.installCode(executionPlanId, result);
            profiler.stop(ProfilerType.TASK_COMPILE_DRIVER_TIME, taskMeta.getId());
            profiler.sum(ProfilerType.TOTAL_DRIVER_COMPILE_TIME, profiler.getTaskTimer(ProfilerType.TASK_COMPILE_DRIVER_TIME, taskMeta.getId()));
            return installedCode;
        }
        catch (Exception e) {
            this.logger.fatal("Unable to compile %s for device %s\n", new Object[]{task.getId(), this.getDeviceName()});
            this.logger.fatal("Exception occurred when compiling %s\n", new Object[]{((CompilableTask)task).getMethod().getName()});
            if (TornadoOptions.RECOVER_BAILOUT) {
                throw new TornadoBailoutRuntimeException("[Error during the Task Compilation]: " + e.getMessage());
            }
            throw e;
        }
    }

    private TornadoInstalledCode compilePreBuiltTask(long executionPlanId, SchedulableTask task) {
        OCLDeviceContextInterface deviceContext = this.getDeviceContext();
        PrebuiltTask executable = (PrebuiltTask)task;
        if (deviceContext.isCached(executionPlanId, task.getId(), executable.getEntryPoint())) {
            return deviceContext.getInstalledCode(executionPlanId, task.getId(), executable.getEntryPoint());
        }
        Path path = Paths.get(executable.getFilename(), new String[0]);
        TornadoInternalError.guarantee((boolean)path.toFile().exists(), (String)"file does not exist: %s", (Object[])new Object[]{executable.getFilename()});
        try {
            byte[] source = Files.readAllBytes(path);
            OCLInstalledCode installedCode = OCLBackend.isDeviceAnFPGAAccelerator(deviceContext) ? deviceContext.installCode(executionPlanId, task.getId(), executable.getEntryPoint(), source, task.meta().isPrintKernelEnabled()) : deviceContext.installCode(executionPlanId, executable.meta(), task.getId(), executable.getEntryPoint(), source);
            return installedCode;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TornadoInstalledCode compileJavaToAccelerator(long executionPlanId, SchedulableTask task) {
        if (task instanceof CompilableTask) {
            return this.compileTask(executionPlanId, task);
        }
        if (task instanceof PrebuiltTask) {
            return this.compilePreBuiltTask(executionPlanId, task);
        }
        TornadoInternalError.shouldNotReachHere((String)("task of unknown type: " + task.getClass().getSimpleName()));
        return null;
    }

    private String getTaskEntryName(SchedulableTask task) {
        return task.getTaskName();
    }

    private TornadoInstalledCode loadPreCompiledBinaryForTask(long executionPlanId, SchedulableTask task) {
        OCLDeviceContextInterface deviceContext = this.getDeviceContext();
        OCLCodeCache codeCache = deviceContext.getCodeCache(executionPlanId);
        String deviceFullName = this.getFullTaskIdDevice(task);
        Path lookupPath = Paths.get(codeCache.getOpenCLBinary(deviceFullName), new String[0]);
        String entry = this.getTaskEntryName(task);
        if (deviceContext.getInstalledCode(executionPlanId, task.getId(), entry) != null) {
            return deviceContext.getInstalledCode(executionPlanId, task.getId(), entry);
        }
        return codeCache.installEntryPointForBinaryForFPGAs(task.getId(), lookupPath, entry);
    }

    private String getFullTaskIdDevice(SchedulableTask task) {
        TaskContextInterface meta = task.meta();
        if (meta instanceof TaskDataContext) {
            TaskDataContext metaData = (TaskDataContext)task.meta();
            return task.getId() + ".device=" + metaData.getBackendIndex() + ":" + metaData.getDeviceIndex();
        }
        throw new RuntimeException("[ERROR] TaskMetadata expected");
    }

    public boolean isFullJITMode(long executionPlanId, SchedulableTask task) {
        String deviceFullName;
        OCLDeviceContextInterface deviceContext = this.getDeviceContext();
        return !this.isOpenCLPreLoadBinary(executionPlanId, deviceContext, deviceFullName = this.getFullTaskIdDevice(task)) && deviceContext.isPlatformFPGA();
    }

    public TornadoInstalledCode getCodeFromCache(long executionPlanId, SchedulableTask task) {
        String entry = this.getTaskEntryName(task);
        return this.getDeviceContext().getInstalledCode(executionPlanId, task.getId(), entry);
    }

    public int[] checkAtomicsForTask(SchedulableTask task) {
        if (TornadoAtomicIntegerNode.globalAtomics.containsKey(task.meta().getCompiledResolvedJavaMethod())) {
            ArrayList<Integer> values = TornadoAtomicIntegerNode.globalAtomics.get(task.meta().getCompiledResolvedJavaMethod());
            int[] atomicsArray = new int[values.size()];
            int j = 0;
            for (Integer i : values) {
                atomicsArray[j++] = i;
            }
            return atomicsArray;
        }
        return null;
    }

    public int[] checkAtomicsForTask(SchedulableTask task, int[] array, int paramIndex, Object value) {
        if (value instanceof AtomicInteger) {
            AtomicInteger ai = (AtomicInteger)value;
            Object compiledResolvedJavaMethod = task.meta().getCompiledResolvedJavaMethod();
            if (TornadoAtomicIntegerNode.globalAtomicsParameters.containsKey(compiledResolvedJavaMethod)) {
                HashMap<Integer, Integer> values = TornadoAtomicIntegerNode.globalAtomicsParameters.get(compiledResolvedJavaMethod);
                int index = values.get(paramIndex);
                array[index] = ai.get();
            }
        }
        return array;
    }

    public int[] updateAtomicRegionAndObjectState(SchedulableTask task, int[] array, int paramIndex, Object value, XPUDeviceBufferState atomicState) {
        int[] atomicsArray = this.checkAtomicsForTask(task, array, paramIndex, value);
        this.mappingAtomics.put(value, this.getAtomicsGlobalIndexForTask(task, paramIndex));
        XPUBuffer xpuBufferForAtomic = atomicState.getXPUBuffer();
        xpuBufferForAtomic.setIntBuffer(atomicsArray);
        this.atomicsBuffer = xpuBufferForAtomic;
        atomicState.setAtomicRegion(xpuBufferForAtomic);
        return atomicsArray;
    }

    public int getAtomicsGlobalIndexForTask(SchedulableTask task, int paramIndex) {
        if (TornadoAtomicIntegerNode.globalAtomicsParameters.containsKey(task.meta().getCompiledResolvedJavaMethod())) {
            HashMap<Integer, Integer> values = TornadoAtomicIntegerNode.globalAtomicsParameters.get(task.meta().getCompiledResolvedJavaMethod());
            return values.get(paramIndex);
        }
        return -1;
    }

    public boolean checkAtomicsParametersForTask(SchedulableTask task) {
        return TornadoAtomicIntegerNode.globalAtomicsParameters.containsKey(task.meta().getCompiledResolvedJavaMethod());
    }

    private boolean isJITTaskForFGPA(long executionPlanId, SchedulableTask task) {
        String deviceFullName;
        OCLDeviceContextInterface deviceContext = this.getDeviceContext();
        return !this.isOpenCLPreLoadBinary(executionPlanId, deviceContext, deviceFullName = this.getFullTaskIdDevice(task)) && deviceContext.isPlatformFPGA();
    }

    private boolean isJITTaskForGPUsAndCPUs(long executionplanId, SchedulableTask task) {
        String deviceFullName;
        OCLDeviceContextInterface deviceContext = this.getDeviceContext();
        return !this.isOpenCLPreLoadBinary(executionplanId, deviceContext, deviceFullName = this.getFullTaskIdDevice(task)) && !deviceContext.isPlatformFPGA();
    }

    private TornadoInstalledCode compileJavaForFPGAs(long executionPlanId, SchedulableTask task) {
        TornadoInstalledCode tornadoInstalledCode = this.compileJavaToAccelerator(executionPlanId, task);
        if (tornadoInstalledCode != null) {
            return this.loadPreCompiledBinaryForTask(executionPlanId, task);
        }
        return null;
    }

    public TornadoInstalledCode installCode(long executionPlanId, SchedulableTask task) {
        if (this.isJITTaskForFGPA(executionPlanId, task)) {
            return this.compileJavaForFPGAs(executionPlanId, task);
        }
        if (this.isJITTaskForGPUsAndCPUs(executionPlanId, task)) {
            return this.compileJavaToAccelerator(executionPlanId, task);
        }
        return this.loadPreCompiledBinaryForTask(executionPlanId, task);
    }

    private XPUBuffer createArrayWrapper(Class<?> type, OCLDeviceContext device, long batchSize, Access access) {
        OCLArrayWrapper result = null;
        if (type == float[].class) {
            result = new OCLFloatArrayWrapper(device, batchSize, access);
        } else if (type == int[].class) {
            result = new OCLIntArrayWrapper(device, batchSize, access);
        } else if (type == double[].class) {
            result = new OCLDoubleArrayWrapper(device, batchSize, access);
        } else if (type == short[].class) {
            result = new OCLShortArrayWrapper(device, batchSize, access);
        } else if (type == byte[].class) {
            result = new OCLByteArrayWrapper(device, batchSize, access);
        } else if (type == long[].class) {
            result = new OCLLongArrayWrapper(device, batchSize, access);
        } else if (type == char[].class) {
            result = new OCLCharArrayWrapper(device, batchSize, access);
        } else {
            TornadoInternalError.unimplemented((String)"array of type %s", (Object[])new Object[]{type.getName()});
        }
        return result;
    }

    private XPUBuffer createMultiArrayWrapper(Class<?> componentType, Class<?> type, OCLDeviceContext device, long batchSize, Access access) {
        OCLMultiDimArrayWrapper result = null;
        if (componentType == int[].class) {
            result = new OCLMultiDimArrayWrapper(device, context -> new OCLIntArrayWrapper((OCLDeviceContext)context, batchSize, access), batchSize, access);
        } else if (componentType == short[].class) {
            result = new OCLMultiDimArrayWrapper(device, context -> new OCLShortArrayWrapper((OCLDeviceContext)context, batchSize, access), batchSize, access);
        } else if (componentType == char[].class) {
            result = new OCLMultiDimArrayWrapper(device, context -> new OCLCharArrayWrapper((OCLDeviceContext)context, batchSize, access), batchSize, access);
        } else if (componentType == byte[].class) {
            result = new OCLMultiDimArrayWrapper(device, context -> new OCLByteArrayWrapper((OCLDeviceContext)context, batchSize, access), batchSize, access);
        } else if (componentType == float[].class) {
            result = new OCLMultiDimArrayWrapper(device, context -> new OCLFloatArrayWrapper((OCLDeviceContext)context, batchSize, access), batchSize, access);
        } else if (componentType == double[].class) {
            result = new OCLMultiDimArrayWrapper(device, context -> new OCLDoubleArrayWrapper((OCLDeviceContext)context, batchSize, access), batchSize, access);
        } else if (componentType == long[].class) {
            result = new OCLMultiDimArrayWrapper(device, context -> new OCLLongArrayWrapper((OCLDeviceContext)context, batchSize, access), batchSize, access);
        } else {
            TornadoInternalError.unimplemented((String)"array of type %s", (Object[])new Object[]{type.getName()});
        }
        return result;
    }

    private XPUBuffer createDeviceBuffer(Class<?> type, Object object, OCLDeviceContext deviceContext, long batchSize, Access access) {
        Object result = null;
        if (type.isArray()) {
            if (!type.getComponentType().isArray()) {
                result = this.createArrayWrapper(type, deviceContext, batchSize, access);
            } else {
                Class<?> componentType = type.getComponentType();
                if (RuntimeUtilities.isPrimitiveArray(componentType)) {
                    result = this.createMultiArrayWrapper(componentType, type, deviceContext, batchSize, access);
                } else {
                    TornadoInternalError.unimplemented((String)"multi-dimensional array of type %s", (Object[])new Object[]{type.getName()});
                }
            }
        } else if (!type.isPrimitive()) {
            result = object instanceof AtomicInteger ? new OCLAtomicsBuffer(new int[0], deviceContext, access) : (object.getClass().getAnnotation(Vector.class) != null ? new OCLVectorWrapper(deviceContext, object, batchSize, access) : (object instanceof MemorySegment ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, 0) : (object instanceof IntArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.INT.getSizeInBytes()) : (object instanceof FloatArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.FLOAT.getSizeInBytes()) : (object instanceof DoubleArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.DOUBLE.getSizeInBytes()) : (object instanceof LongArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.LONG.getSizeInBytes()) : (object instanceof ShortArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.SHORT.getSizeInBytes()) : (object instanceof ByteArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.CHAR.getSizeInBytes()) : (object instanceof CharArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.CHAR.getSizeInBytes()) : (object instanceof HalfFloatArray ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.HALF.getSizeInBytes()) : (object instanceof Int8Array ? new OCLMemorySegmentWrapper(deviceContext, batchSize, access, OCLKind.CHAR.getSizeInBytes()) : new OCLFieldBuffer(deviceContext, object, access))))))))))));
        }
        TornadoInternalError.guarantee((result != null ? 1 : 0) != 0, (String)("Unable to create buffer for object: " + String.valueOf(type)), (Object[])new Object[0]);
        return result;
    }

    private HashMap<Access, Integer> getNumOfDistinctAccess(Access[] accesses) {
        HashMap<Access, Integer> distinctAccesses = new HashMap<Access, Integer>();
        for (Access access : accesses) {
            if (distinctAccesses.containsKey(access)) {
                int numOfAccesses = distinctAccesses.get(access);
                distinctAccesses.replace(access, numOfAccesses, numOfAccesses + 1);
                continue;
            }
            distinctAccesses.put(access, 1);
        }
        return distinctAccesses;
    }

    public synchronized long allocateObjects(Object[] objects, long batchSize, DeviceBufferState[] states, Access[] accesses) {
        TornadoBufferProvider bufferProvider = this.getDeviceContext().getBufferProvider();
        HashMap<Access, Integer> distinctAccesses = this.getNumOfDistinctAccess(accesses);
        for (Access access : distinctAccesses.keySet()) {
            int numOfObjectsForAccessType = distinctAccesses.get(access);
            if (bufferProvider.isNumFreeBuffersAvailable(numOfObjectsForAccessType, access)) continue;
            bufferProvider.resetBuffers(access);
        }
        long allocatedSpace = 0L;
        for (int i = 0; i < objects.length; ++i) {
            if (this.reuseBatchBuffer(batchSize, accesses[i], bufferProvider, distinctAccesses, states[i])) continue;
            this.logger.debug("Allocate object %s with access: %s", new Object[]{objects[i], accesses[i]});
            allocatedSpace += this.allocate(objects[i], batchSize, states[i], accesses[i]);
        }
        return allocatedSpace;
    }

    private boolean reuseBatchBuffer(long batchSize, Access access, TornadoBufferProvider bufferProvider, HashMap<Access, Integer> distinctAccesses, DeviceBufferState state) {
        int numberOfBuffersForAccessType;
        if (batchSize != 0L && bufferProvider.reuseBufferForBatchProcessing(batchSize, access, numberOfBuffersForAccessType = distinctAccesses.get(access).intValue())) {
            state.markBufferAsReused();
            return true;
        }
        return false;
    }

    private XPUBuffer newDeviceBufferAllocation(Object object, long batchSize, DeviceBufferState deviceObjectState, Access access) {
        TornadoInternalError.guarantee((deviceObjectState.isAtomicRegionPresent() || !deviceObjectState.hasObjectBuffer() || batchSize != 0L ? 1 : 0) != 0, (String)"A device memory leak might be occurring.", (Object[])new Object[0]);
        XPUBuffer buffer = this.createDeviceBuffer(object.getClass(), object, (OCLDeviceContext)this.getDeviceContext(), batchSize, access);
        deviceObjectState.setXPUBuffer(buffer);
        buffer.allocate(object, batchSize, access);
        return buffer;
    }

    public long allocate(Object object, long batchSize, DeviceBufferState state, Access access) {
        XPUBuffer buffer;
        if (state.hasObjectBuffer() && state.isLockedBuffer()) {
            buffer = state.getXPUBuffer();
            if (batchSize != 0L) {
                buffer.setSizeSubRegion(batchSize);
            }
        } else {
            buffer = this.newDeviceBufferAllocation(object, batchSize, state, access);
        }
        if (buffer.getClass() == OCLAtomicsBuffer.class) {
            state.setAtomicRegion();
        }
        return state.getXPUBuffer().size();
    }

    public synchronized long deallocate(DeviceBufferState deviceBufferState) {
        long deallocatedSpace = 0L;
        if (deviceBufferState.isLockedBuffer()) {
            return deallocatedSpace;
        }
        deviceBufferState.getXPUBuffer().markAsFreeBuffer();
        if (TornadoOptions.isDeallocateBufferEnabled()) {
            deallocatedSpace = deviceBufferState.getXPUBuffer().deallocate();
        }
        deviceBufferState.setContents(false);
        deviceBufferState.setXPUBuffer(null);
        return deallocatedSpace;
    }

    public List<Integer> ensurePresent(long executionPlanId, Object object, DeviceBufferState state, int[] events, long batchSize, long offset) {
        if (!state.hasContent()) {
            state.setContents(true);
            return state.getXPUBuffer().enqueueWrite(executionPlanId, object, batchSize, offset, events, events == null);
        }
        return null;
    }

    public List<Integer> streamIn(long executionPlanId, Object object, long batchSize, long offset, DeviceBufferState state, int[] events) {
        state.setContents(true);
        return state.getXPUBuffer().enqueueWrite(executionPlanId, object, batchSize, offset, events, events == null);
    }

    public int streamOut(long executionPlanId, Object object, long offset, DeviceBufferState state, int[] events) {
        TornadoInternalError.guarantee((boolean)state.hasObjectBuffer(), (String)"invalid variable", (Object[])new Object[0]);
        int event = state.getXPUBuffer().enqueueRead(executionPlanId, object, offset, events, events == null);
        if (events != null) {
            return event;
        }
        return -1;
    }

    public int streamOutBlocking(long executionPlanId, Object object, long hostOffset, DeviceBufferState state, int[] events) {
        long partialCopySize = state.getPartialCopySize();
        if (state.isAtomicRegionPresent()) {
            int eventID = state.getXPUBuffer().enqueueRead(executionPlanId, null, 0L, null, false);
            if (object instanceof AtomicInteger) {
                int[] arr = this.getAtomic().getIntBuffer();
                int indexFromGlobalRegion = this.mappingAtomics.get(object);
                ((AtomicInteger)object).set(arr[indexFromGlobalRegion]);
            }
            return eventID;
        }
        TornadoInternalError.guarantee((boolean)state.hasObjectBuffer(), (String)"invalid variable", (Object[])new Object[0]);
        return state.getXPUBuffer().read(executionPlanId, object, hostOffset, partialCopySize, events, events == null);
    }

    public void flush(long executionPlanId) {
        this.getDeviceContext().flush(executionPlanId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OCLTornadoDevice) {
            OCLTornadoDevice other = (OCLTornadoDevice)obj;
            return other.deviceIndex == this.deviceIndex && other.platformIndex == this.platformIndex;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.deviceIndex;
        hash = 89 * hash + this.platformIndex;
        return hash;
    }

    public void sync(long executionPlanId) {
        this.getDeviceContext().sync(executionPlanId);
    }

    public int enqueueBarrier(long executionPlanId) {
        return this.getDeviceContext().enqueueBarrier(executionPlanId);
    }

    public int enqueueBarrier(long executionPlanId, int[] events) {
        return this.getDeviceContext().enqueueBarrier(executionPlanId, events);
    }

    public int enqueueMarker(long executionPlanId) {
        return this.getDeviceContext().enqueueMarker(executionPlanId);
    }

    public int enqueueMarker(long executionPlanId, int[] events) {
        return this.getDeviceContext().enqueueMarker(executionPlanId, events);
    }

    public Event resolveEvent(long executionPlanId, int event) {
        return this.getDeviceContext().resolveEvent(executionPlanId, event);
    }

    public void flushEvents(long executionPlanId) {
        this.getDeviceContext().flushEvents(executionPlanId);
    }

    public String getDeviceName() {
        return String.format("opencl-%d-%d", this.platformIndex, this.deviceIndex);
    }

    public TornadoDeviceType getDeviceType() {
        OCLDeviceType deviceType = this.device.getDeviceType();
        return switch (deviceType) {
            case OCLDeviceType.CL_DEVICE_TYPE_CPU -> TornadoDeviceType.CPU;
            case OCLDeviceType.CL_DEVICE_TYPE_GPU -> TornadoDeviceType.GPU;
            case OCLDeviceType.CL_DEVICE_TYPE_ACCELERATOR -> TornadoDeviceType.ACCELERATOR;
            case OCLDeviceType.CL_DEVICE_TYPE_CUSTOM -> TornadoDeviceType.CUSTOM;
            case OCLDeviceType.CL_DEVICE_TYPE_ALL -> TornadoDeviceType.ALL;
            case OCLDeviceType.CL_DEVICE_TYPE_DEFAULT -> TornadoDeviceType.DEFAULT;
            default -> throw new RuntimeException("Device not supported");
        };
    }

    public long getMaxAllocMemory() {
        return this.device.getDeviceMaxAllocationSize();
    }

    public long getMaxGlobalMemory() {
        return this.device.getDeviceGlobalMemorySize();
    }

    public long getDeviceLocalMemorySize() {
        return this.device.getDeviceLocalMemorySize();
    }

    public long[] getDeviceMaxWorkgroupDimensions() {
        return this.device.getDeviceMaxWorkItemSizes();
    }

    public String getDeviceOpenCLCVersion() {
        return this.device.getDeviceOpenCLCVersion();
    }

    public Object getDeviceInfo() {
        return this.device.getDeviceInfo();
    }

    public int getBackendIndex() {
        return TornadoCoreRuntime.getTornadoRuntime().getBackendIndex(OCLBackendImpl.class);
    }

    public XPUBuffer getAtomic() {
        return this.atomicsBuffer;
    }

    public void setAtomicsMapping(ConcurrentHashMap<Object, Integer> mappingAtomics) {
        this.mappingAtomics = mappingAtomics;
    }

    public void enableThreadSharing() {
    }

    public void setAtomicRegion(XPUBuffer bufferAtomics) {
        this.atomicsBuffer = bufferAtomics;
    }

    public TornadoVMBackendType getTornadoVMBackend() {
        return TornadoVMBackendType.OPENCL;
    }

    public boolean isSPIRVSupported() {
        String version = this.device.getDeviceContext().getPlatformContext().getPlatform().getVersion();
        if (version.contains("CUDA")) {
            return false;
        }
        Matcher matcher = NAME_PATTERN.matcher(version);
        int majorVersion = 0;
        int minorVersion = 0;
        if (matcher.find()) {
            majorVersion = Integer.parseInt(matcher.group(1));
            minorVersion = Integer.parseInt(matcher.group(2));
        }
        if (majorVersion > 2) {
            return true;
        }
        return majorVersion == 2 && minorVersion >= 1;
    }

    public void mapDeviceRegion(long executionPlanId, Object destArray, Object srcArray, DeviceBufferState deviceStateSrc, DeviceBufferState deviceStateDest, long offset) {
        XPUBuffer devicePointer = deviceStateDest.getXPUBuffer();
        XPUBuffer srcPointer = deviceStateSrc.getXPUBuffer();
        devicePointer.mapOnDeviceMemoryRegion(executionPlanId, srcPointer, offset);
    }
}

