/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.runtime;

import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.drivers.common.TornadoBufferProvider;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;

public class OCLBufferProvider
extends TornadoBufferProvider {
    public OCLBufferProvider(OCLDeviceContext deviceContext) {
        super((TornadoDeviceContext)deviceContext);
    }

    public long allocateBuffer(long size, Access access) {
        long oclMemFlags = OCLBufferProvider.getOCLMemFlagForAccess(access);
        return ((OCLDeviceContext)this.deviceContext).getMemoryManager().createBuffer(size, oclMemFlags).getBuffer();
    }

    protected void releaseBuffer(long buffer) {
        ((OCLDeviceContext)this.deviceContext).getMemoryManager().releaseBuffer(buffer);
    }

    private static long getOCLMemFlagForAccess(Access access) {
        switch (access) {
            case READ_ONLY: {
                return 4L;
            }
            case WRITE_ONLY: {
                return 2L;
            }
            case READ_WRITE: {
                return 1L;
            }
        }
        return 1L;
    }
}

