/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.drivers.opencl.power;

import uk.ac.manchester.tornado.drivers.common.power.PowerMetric;
import uk.ac.manchester.tornado.drivers.opencl.OCLDeviceContext;
import uk.ac.manchester.tornado.drivers.opencl.exceptions.OCLException;
import uk.ac.manchester.tornado.runtime.common.TornadoLogger;

public class OCLNvidiaPowerMetricHandler
implements PowerMetric {
    private final OCLDeviceContext deviceContext;
    private final TornadoLogger logger;
    private long[] oclDevice = new long[1];

    public OCLNvidiaPowerMetricHandler(OCLDeviceContext deviceContext) {
        this.deviceContext = deviceContext;
        this.logger = new TornadoLogger(this.getClass());
        this.initializePowerLibrary();
    }

    static native long clNvmlInit() throws OCLException;

    static native long clNvmlDeviceGetHandleByIndex(long var0, long[] var2) throws OCLException;

    static native long clNvmlDeviceGetPowerUsage(long[] var0, long[] var1) throws OCLException;

    public void initializePowerLibrary() {
        try {
            OCLNvidiaPowerMetricHandler.clNvmlInit();
            OCLNvidiaPowerMetricHandler.clNvmlDeviceGetHandleByIndex(this.deviceContext.getDevice().getIndex(), this.oclDevice);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void getPowerUsage(long[] powerUsage) {
        try {
            OCLNvidiaPowerMetricHandler.clNvmlDeviceGetPowerUsage(this.oclDevice, powerUsage);
        }
        catch (OCLException e) {
            this.logger.error(e.getMessage());
        }
    }
}

